<?php
// Arquivo de autoload para carregar classes automaticamente

spl_autoload_register(function ($class) {
    // Converter namespace para caminho de arquivo
    $prefix = '';
    $base_dir = __DIR__ . '/src/';
    
    // Verificar se a classe usa o prefixo do namespace
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        // Não, mover para o próximo autoloader registrado
        return;
    }
    
    // Obter o caminho relativo da classe
    $relative_class = substr($class, $len);
    
    // Substituir separadores de namespace por separadores de diretório
    // Adicionar .php
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
    
    // Se o arquivo existir, carregá-lo
    if (file_exists($file)) {
        require $file;
    }
});
