<?php
require_once '../config.php';

// Verificar se o usuário está logado
if (!isLoggedIn()) {
    redirect('../login.php');
}

// Processar exclusão
if (isset($_GET['delete']) && !empty($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    
    // Obter informações da rede social para excluir o ícone personalizado
    $sql = "SELECT custom_icon_url FROM socials WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $stmt->close();
    
    if ($result->num_rows === 1) {
        $social = $result->fetch_assoc();
        if (!empty($social['custom_icon_url'])) {
            $iconPath = '../' . $social['custom_icon_url'];
            if (file_exists($iconPath)) {
                unlink($iconPath);
            }
        }
    }
    
    $sql = "DELETE FROM socials WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->close();
    
    // Redirecionar para evitar reenvio do formulário
    redirect('socials.php?msg=deleted');
}

// Processar alteração de status
if (isset($_GET['toggle']) && !empty($_GET['toggle'])) {
    $id = (int)$_GET['toggle'];
    
    // Obter status atual
    $sql = "SELECT is_active FROM socials WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $stmt->close();
    
    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        $newStatus = $row['is_active'] ? 0 : 1;
        
        // Atualizar status
        $sql = "UPDATE socials SET is_active = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ii", $newStatus, $id);
        $stmt->execute();
        $stmt->close();
    }
    
    // Redirecionar para evitar reenvio do formulário
    redirect('socials.php?msg=updated');
}

// Processar formulário de adição/edição
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $platform = sanitize($_POST['platform']);
    $url = sanitize($_POST['url']);
    $icon = sanitize($_POST['icon']);
    $order = (int)$_POST['order'];
    $isActive = isset($_POST['is_active']) ? 1 : 0;
    
    if (empty($platform) || empty($url)) {
        $error = 'Plataforma e URL são obrigatórios.';
    } else {
        $customIconUrl = '';
        $uploadOk = true;
        
        // Verificar se um ícone personalizado foi enviado
        if (isset($_FILES['custom_icon']) && $_FILES['custom_icon']['error'] === 0) {
            $uploadDir = '../uploads/socials/';
            
            // Criar diretório se não existir
            if (!file_exists($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }
            
            $fileName = basename($_FILES['custom_icon']['name']);
            $fileType = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
            $newFileName = 'icon-' . time() . '-' . rand(1000, 9999) . '.' . $fileType;
            $targetFile = $uploadDir . $newFileName;
            
            // Verificar se é uma imagem real
            $check = getimagesize($_FILES['custom_icon']['tmp_name']);
            if ($check === false) {
                $error = 'O arquivo não é uma imagem válida.';
                $uploadOk = false;
            }
            
            // Verificar o tamanho do arquivo (máximo 1MB)
            if ($_FILES['custom_icon']['size'] > 1000000) {
                $error = 'O arquivo é muito grande. Tamanho máximo: 1MB.';
                $uploadOk = false;
            }
            
            // Permitir apenas certos formatos de arquivo
            if ($fileType != "jpg" && $fileType != "png" && $fileType != "jpeg" && $fileType != "gif" && $fileType != "webp" && $fileType != "svg") {
                $error = 'Apenas arquivos JPG, JPEG, PNG, GIF, WEBP e SVG são permitidos.';
                $uploadOk = false;
            }
            
            // Fazer upload do arquivo
            if ($uploadOk) {
                if (move_uploaded_file($_FILES['custom_icon']['tmp_name'], $targetFile)) {
                    $customIconUrl = 'uploads/socials/' . $newFileName;
                } else {
                    $error = 'Ocorreu um erro ao fazer upload do ícone.';
                    $uploadOk = false;
                }
            }
        }
        
        if (!isset($error)) {
            if (isset($_POST['id']) && !empty($_POST['id'])) {
                // Atualizar rede social existente
                $id = (int)$_POST['id'];
                
                if (!empty($customIconUrl)) {
                    // Se um novo ícone foi enviado, excluir o antigo
                    $sql = "SELECT custom_icon_url FROM socials WHERE id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("i", $id);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    $stmt->close();
                    
                    if ($result->num_rows === 1) {
                        $social = $result->fetch_assoc();
                        if (!empty($social['custom_icon_url'])) {
                            $oldIconPath = '../' . $social['custom_icon_url'];
                            if (file_exists($oldIconPath)) {
                                unlink($oldIconPath);
                            }
                        }
                    }
                    
                    // Atualizar com novo ícone
                    $sql = "UPDATE socials SET platform = ?, url = ?, icon = ?, custom_icon_url = ?, order_position = ?, is_active = ? WHERE id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("sssssii", $platform, $url, $icon, $customIconUrl, $order, $isActive, $id);
                } else {
                    // Manter o ícone atual
                    $sql = "UPDATE socials SET platform = ?, url = ?, icon = ?, order_position = ?, is_active = ? WHERE id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("sssiii", $platform, $url, $icon, $order, $isActive, $id);
                }
            } else {
                // Adicionar nova rede social
                $sql = "INSERT INTO socials (platform, url, icon, custom_icon_url, order_position, is_active) VALUES (?, ?, ?, ?, ?, ?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("ssssii", $platform, $url, $icon, $customIconUrl, $order, $isActive);
            }
            
            $stmt->execute();
            $stmt->close();
            
            // Redirecionar para evitar reenvio do formulário
            redirect('socials.php?msg=success');
        }
    }
}

// Obter rede social para edição
$editSocial = null;
if (isset($_GET['edit']) && !empty($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $sql = "SELECT * FROM socials WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $stmt->close();
    
    if ($result->num_rows === 1) {
        $editSocial = $result->fetch_assoc();
    }
}

// Obter todas as redes sociais
$sql = "SELECT * FROM socials ORDER BY order_position ASC";
$socials_result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Redes Sociais - Painel Administrativo</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        :root {
            --color-dark: #121212;
            --color-secondary: #1e1e1e;
            --color-primary: #6d28d9;
            --color-accent: #8b5cf6;
            --color-light: #f3f4f6;
        }
        body {
            background-color: var(--color-dark);
            color: var(--color-light);
            font-family: 'Inter', sans-serif;
        }
        .input {
            width: 100%;
            padding: 0.75rem;
            border-radius: 0.375rem;
            background-color: #2d2d2d;
            color: var(--color-light);
            border: 1px solid #3d3d3d;
        }
        .input:focus {
            outline: none;
            border-color: var(--color-accent);
        }
        .btn {
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .btn-primary {
            background-color: var(--color-primary);
            color: white;
        }
        .btn-primary:hover {
            background-color: var(--color-accent);
        }
        .btn-secondary {
            background-color: #2d2d2d;
            color: var(--color-light);
        }
        .btn-secondary:hover {
            background-color: #3d3d3d;
        }
    </style>
</head>
<body>
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <?php include 'sidebar.php'; ?>
        
        <!-- Main Content -->
        <div class="flex-1 ml-64">
            <header class="bg-secondary p-4 shadow-md">
                <div class="flex justify-between items-center">
                    <h2 class="text-xl font-semibold text-light">Painel Administrativo</h2>
                    <div>
                        <a href="../index.php" target="_blank" class="btn btn-secondary text-sm">
                            Ver Página
                        </a>
                    </div>
                </div>
            </header>
            
            <main class="p-6">
                <div class="bg-secondary rounded-lg p-6 shadow-lg">
                    <div class="flex justify-between items-center mb-6">
                        <h1 class="text-2xl font-bold text-light">Gerenciar Redes Sociais</h1>
                        <?php if (!$editSocial): ?>
                            <button 
                                onclick="document.getElementById('formSection').classList.toggle('hidden')"
                                class="btn btn-primary"
                            >
                                Adicionar Rede Social
                            </button>
                        <?php endif; ?>
                    </div>
                    
                    <?php if (isset($_GET['msg'])): ?>
                        <div class="mb-4 p-3 rounded 
                            <?php echo $_GET['msg'] === 'deleted' ? 'bg-red-900/30 border border-red-800 text-red-300' : 'bg-green-900/30 border border-green-800 text-green-300'; ?>">
                            <?php 
                                if ($_GET['msg'] === 'success') echo 'Rede social salva com sucesso!';
                                elseif ($_GET['msg'] === 'deleted') echo 'Rede social excluída com sucesso!';
                                elseif ($_GET['msg'] === 'updated') echo 'Status da rede social atualizado com sucesso!';
                            ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($error)): ?>
                        <div class="mb-4 p-3 rounded bg-red-900/30 border border-red-800 text-red-300">
                            <?php echo $error; ?>
                        </div>
                    <?php endif; ?>
                    
                    <div id="formSection" class="<?php echo $editSocial ? '' : 'hidden'; ?> mb-8 bg-dark p-6 rounded-lg">
                        <h2 class="text-xl font-semibold text-light mb-4">
                            <?php echo $editSocial ? 'Editar Rede Social' : 'Nova Rede Social'; ?>
                        </h2>
                        <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" enctype="multipart/form-data" class="space-y-4">
                            <?php if ($editSocial): ?>
                                <input type="hidden" name="id" value="<?php echo $editSocial['id']; ?>">
                            <?php endif; ?>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-300 mb-1">
                                    Plataforma
                                </label>
                                <input
                                    type="text"
                                    name="platform"
                                    class="input"
                                    value="<?php echo $editSocial ? htmlspecialchars($editSocial['platform']) : ''; ?>"
                                    required
                                    placeholder="Ex: Instagram, YouTube, Twitter"
                                />
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-300 mb-1">
                                    URL
                                </label>
                                <input
                                    type="url"
                                    name="url"
                                    class="input"
                                    value="<?php echo $editSocial ? htmlspecialchars($editSocial['url']) : ''; ?>"
                                    required
                                    placeholder="https://"
                                />
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-300 mb-1">
                                    Ícone (Emoji)
                                </label>
                                <input
                                    type="text"
                                    name="icon"
                                    class="input"
                                    value="<?php echo $editSocial ? htmlspecialchars($editSocial['icon']) : ''; ?>"
                                    placeholder="Emoji ou código do ícone (usado se não houver ícone personalizado)"
                                />
                                <p class="text-sm text-gray-400 mt-1">
                                    Este ícone será usado se não houver um ícone personalizado.
                                </p>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-300 mb-1">
                                    Ícone Personalizado
                                </label>
                                <input
                                    type="file"
                                    name="custom_icon"
                                    class="input"
                                    accept="image/*"
                                />
                                <?php if ($editSocial && !empty($editSocial['custom_icon_url'])): ?>
                                    <div class="mt-2 flex items-center">
                                        <img 
                                            src="../<?php echo htmlspecialchars($editSocial['custom_icon_url']); ?>" 
                                            alt="Ícone atual" 
                                            class="w-10 h-10 object-contain rounded mr-2"
                                        >
                                        <p class="text-sm text-gray-400">
                                            Ícone atual. Envie uma nova imagem para substituí-lo ou deixe em branco para manter.
                                        </p>
                                    </div>
                                <?php endif; ?>
                                <p class="text-sm text-gray-400 mt-1">
                                    Tamanho máximo: 1MB. Formatos permitidos: JPG, PNG, GIF, WEBP, SVG.
                                </p>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-300 mb-1">
                                    Ordem
                                </label>
                                <input
                                    type="number"
                                    name="order"
                                    class="input"
                                    value="<?php echo $editSocial ? (int)$editSocial['order_position'] : 0; ?>"
                                    min="0"
                                />
                            </div>
                            
                            <div class="flex items-center">
                                <input
                                    type="checkbox"
                                    id="is_active"
                                    name="is_active"
                                    class="mr-2"
                                    <?php echo (!$editSocial || $editSocial['is_active']) ? 'checked' : ''; ?>
                                />
                                <label for="is_active" class="text-sm font-medium text-gray-300">
                                    Ativo
                                </label>
                            </div>
                            
                            <div class="flex space-x-3">
                                <button type="submit" class="btn btn-primary">
                                    <?php echo $editSocial ? 'Salvar Alterações' : 'Adicionar Rede Social'; ?>
                                </button>
                                <a 
                                    href="socials.php" 
                                    class="btn btn-secondary"
                                >
                                    Cancelar
                                </a>
                            </div>
                        </form>
                    </div>
                    
                    <div class="space-y-4">
                        <?php if ($socials_result->num_rows === 0): ?>
                            <p class="text-gray-400 text-center py-8">Nenhuma rede social cadastrada.</p>
                        <?php else: ?>
                            <?php while($social = $socials_result->fetch_assoc()): ?>
                                <div 
                                    class="flex items-center justify-between p-4 rounded-lg <?php echo $social['is_active'] ? 'bg-dark' : 'bg-dark/50'; ?> border <?php echo $social['is_active'] ? 'border-gray-700' : 'border-gray-800'; ?>"
                                >
                                    <div class="flex items-center">
                                        <?php if (!empty($social['custom_icon_url'])): ?>
                                            <div class="w-10 h-10 rounded-full flex items-center justify-center mr-4 overflow-hidden bg-gray-800 flex-shrink-0">
                                                <img 
                                                    src="../<?php echo htmlspecialchars($social['custom_icon_url']); ?>" 
                                                    alt="<?php echo htmlspecialchars($social['platform']); ?>" 
                                                    class="w-6 h-6 object-contain"
                                                    onerror="this.parentNode.innerHTML='<?php echo htmlspecialchars($social['icon']); ?>'"
                                                >
                                            </div>
                                        <?php else: ?>
                                            <div class="w-10 h-10 rounded-full bg-primary flex items-center justify-center mr-4 flex-shrink-0">
                                                <span class="text-white"><?php echo htmlspecialchars($social['icon']); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        <div>
                                            <h3 class="font-medium <?php echo $social['is_active'] ? 'text-light' : 'text-gray-400'; ?>">
                                                <?php echo htmlspecialchars($social['platform']); ?>
                                            </h3>
                                            <p class="text-sm text-gray-500 truncate max-w-md">
                                                <?php echo htmlspecialchars($social['url']); ?>
                                            </p>
                                            <p class="text-xs text-gray-600 mt-1">
                                                Ordem: <?php echo (int)$social['order_position']; ?>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="flex space-x-2">
                                        <a 
                                            href="?toggle=<?php echo $social['id']; ?>"
                                            class="p-2 text-gray-400 hover:text-light"
                                            title="<?php echo $social['is_active'] ? 'Desativar' : 'Ativar'; ?>"
                                        >
                                            <?php echo $social['is_active'] ? '👁️' : '👁️‍🗨️'; ?>
                                        </a>
                                        <a 
                                            href="?edit=<?php echo $social['id']; ?>"
                                            class="p-2 text-gray-400 hover:text-light"
                                            title="Editar"
                                        >
                                            ✏️
                                        </a>
                                        <a 
                                            href="?delete=<?php echo $social['id']; ?>"
                                            class="p-2 text-gray-400 hover:text-red-500"
                                            title="Excluir"
                                            onclick="return confirm('Tem certeza que deseja excluir esta rede social?');"
                                        >
                                            🗑️
                                        </a>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>
