<?php
require_once 'config.php';

// Obter links ativos
$sql = "SELECT * FROM links WHERE is_active = 1 ORDER BY order_position ASC";
$links_result = $conn->query($sql);

// Obter banners ativos
$sql = "SELECT * FROM banners WHERE is_active = 1 ORDER BY order_position ASC";
$banners_result = $conn->query($sql);

// Obter redes sociais ativas
$sql = "SELECT * FROM socials WHERE is_active = 1 ORDER BY order_position ASC";
$socials_result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Renan Peterlini</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        :root {
            --color-dark: #121212;
            --color-secondary: #1e1e1e;
            --color-primary: #6d28d9;
            --color-accent: #8b5cf6;
            --color-light: #f3f4f6;
        }
        body {
            background-color: var(--color-dark);
            color: var(--color-light);
            font-family: 'Inter', sans-serif;
        }
        .container-custom {
            width: 100%;
            max-width: 640px;
            margin: 0 auto;
            padding: 0 1rem;
        }
        .bg-dark {
            background-color: var(--color-dark);
        }
        .bg-secondary {
            background-color: var(--color-secondary);
        }
        .bg-primary {
            background-color: var(--color-primary);
        }
        .text-light {
            color: var(--color-light);
        }
        .text-accent {
            color: var(--color-accent);
        }
        .shadow-custom {
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .link-card {
            display: block;
            padding: 1rem;
            background-color: var(--color-secondary);
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }
        .link-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .social-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 3rem;
            height: 3rem;
            background-color: var(--color-primary);
            border-radius: 9999px;
            transition: all 0.3s ease;
        }
        .social-icon:hover {
            background-color: var(--color-accent);
            transform: scale(1.1);
        }
    </style>
</head>
<body>
    <header class="py-6 bg-secondary">
        <div class="container-custom">
            <div class="flex flex-col items-center justify-center">
                <img 
                    src="uploads/profile.jpg" 
                    alt="Renan Peterlini" 
                    class="w-24 h-24 rounded-full border-2 border-accent mb-4"
                    onerror="this.src='https://via.placeholder.com/96x96?text=RP'"
                >
                <h1 class="text-2xl font-bold text-light">Renan Peterlini</h1>
                <p class="text-gray-400">Jogador de Poker, entusiasta das apostas</p>
            </div>
        </div>
    </header>

    <main class="container-custom py-8">
        <!-- Banner Section -->
        <section class="mb-10">
            <?php if ($banners_result->num_rows > 0): ?>
                <div class="bg-secondary rounded-lg overflow-hidden shadow-custom">
                    <?php $banner = $banners_result->fetch_assoc(); ?>
                    <a href="<?php echo htmlspecialchars($banner['link_url']); ?>" target="_blank">
                        <img 
                            src="<?php echo htmlspecialchars($banner['image_url']); ?>" 
                            alt="<?php echo htmlspecialchars($banner['title']); ?>" 
                            class="w-full h-48 object-cover"
                            onerror="this.src='https://via.placeholder.com/800x300?text=Banner'"
                        >
                    </a>
                </div>
            <?php endif; ?>
        </section>

        <!-- Links Section -->
        <section class="mb-10">
            <h2 class="text-xl font-semibold text-light mb-4">Links</h2>
            <div class="space-y-3">
                <?php if ($links_result->num_rows > 0): ?>
                    <?php while($link = $links_result->fetch_assoc()): ?>
                        <a 
                            href="<?php echo htmlspecialchars($link['url']); ?>" 
                            target="_blank"
                            class="link-card"
                        >
                            <div class="flex items-center w-full">
                                <?php if (!empty($link['image_url'])): ?>
                                    <div class="w-12 h-12 rounded-lg overflow-hidden mr-4 bg-gray-800 flex-shrink-0">
                                        <img 
                                            src="<?php echo htmlspecialchars($link['image_url']); ?>" 
                                            alt="<?php echo htmlspecialchars($link['title']); ?>" 
                                            class="w-full h-full object-cover"
                                            onerror="this.parentNode.innerHTML='<div class=\'w-10 h-10 rounded-full bg-primary flex items-center justify-center\'><span class=\'text-white\'><?php echo htmlspecialchars($link['icon']); ?></span></div>'"
                                        >
                                    </div>
                                <?php else: ?>
                                    <div class="w-10 h-10 rounded-full bg-primary flex items-center justify-center mr-4">
                                        <span class="text-white"><?php echo htmlspecialchars($link['icon']); ?></span>
                                    </div>
                                <?php endif; ?>
                                <span class="text-light"><?php echo htmlspecialchars($link['title']); ?></span>
                            </div>
                        </a>
                    <?php endwhile; ?>
                <?php else: ?>
                    <p class="text-gray-400 text-center">Nenhum link disponível no momento.</p>
                <?php endif; ?>
            </div>
        </section>

        <!-- Social Media Section -->
        <section class="mb-10">
            <h2 class="text-xl font-semibold text-light mb-4">Redes Sociais</h2>
            <div class="flex flex-wrap gap-4">
                <?php if ($socials_result->num_rows > 0): ?>
                    <?php while($social = $socials_result->fetch_assoc()): ?>
                        <a 
                            href="<?php echo htmlspecialchars($social['url']); ?>" 
                            target="_blank"
                            class="social-icon"
                            title="<?php echo htmlspecialchars($social['platform']); ?>"
                        >
                            <?php if (!empty($social['custom_icon_url'])): ?>
                                <img 
                                    src="<?php echo htmlspecialchars($social['custom_icon_url']); ?>" 
                                    alt="<?php echo htmlspecialchars($social['platform']); ?>" 
                                    class="w-5 h-5 object-contain"
                                    onerror="this.parentNode.innerHTML='<span class=\'text-white\'><?php echo htmlspecialchars($social['icon']); ?></span>'"
                                >
                            <?php else: ?>
                                <span class="text-white"><?php echo htmlspecialchars($social['icon']); ?></span>
                            <?php endif; ?>
                        </a>
                    <?php endwhile; ?>
                <?php else: ?>
                    <p class="text-gray-400 text-center w-full">Nenhuma rede social disponível no momento.</p>
                <?php endif; ?>
            </div>
        </section>
    </main>

    <footer class="py-6 bg-secondary">
        <div class="container-custom text-center">
            <p class="text-gray-400">© <?php echo date('Y'); ?> Renan Peterlini. Todos os direitos reservados.</p>
        </div>
    </footer>
</body>
</html>
