<?php
// Script para atualizar o banco de dados e adicionar suporte a miniaturas e ícones personalizados
// Salve este arquivo como update_features.php na raiz do seu site

// Configurações de conexão com o banco de dados
$db_host = 'localhost';
$db_user = 'seu_usuario'; // Altere para o seu usuário do banco de dados
$db_pass = 'sua_senha';   // Altere para a sua senha do banco de dados
$db_name = 'renanpeterlini'; // Altere para o nome do seu banco de dados

// Mensagem de status
$message = '';

// Processar o formulário quando enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verificar se a senha de segurança está correta
    $security_password = $_POST['security_password'] ?? '';
    
    if ($security_password !== 'atualizar123') { // Altere esta senha de segurança!
        $message = '<div class="error">Senha de segurança incorreta!</div>';
    } else {
        // Conectar ao banco de dados
        $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
        
        // Verificar conexão
        if ($conn->connect_error) {
            $message = '<div class="error">Falha na conexão com o banco de dados: ' . $conn->connect_error . '</div>';
        } else {
            // Verificar se a coluna image_url já existe na tabela links
            $check_column_links = $conn->query("SHOW COLUMNS FROM links LIKE 'image_url'");
            $links_column_exists = $check_column_links->num_rows > 0;
            
            // Verificar se a coluna custom_icon_url já existe na tabela socials
            $check_column_socials = $conn->query("SHOW COLUMNS FROM socials LIKE 'custom_icon_url'");
            $socials_column_exists = $check_column_socials->num_rows > 0;
            
            $success = true;
            $errors = [];
            
            // Adicionar coluna image_url à tabela links se não existir
            if (!$links_column_exists) {
                $alter_links = "ALTER TABLE links ADD COLUMN image_url VARCHAR(255) DEFAULT NULL AFTER icon";
                if (!$conn->query($alter_links)) {
                    $success = false;
                    $errors[] = "Erro ao adicionar coluna image_url à tabela links: " . $conn->error;
                }
            }
            
            // Adicionar coluna custom_icon_url à tabela socials se não existir
            if (!$socials_column_exists) {
                $alter_socials = "ALTER TABLE socials ADD COLUMN custom_icon_url VARCHAR(255) DEFAULT NULL AFTER icon";
                if (!$conn->query($alter_socials)) {
                    $success = false;
                    $errors[] = "Erro ao adicionar coluna custom_icon_url à tabela socials: " . $conn->error;
                }
            }
            
            // Criar diretórios para uploads se não existirem
            $upload_dirs = [
                '../uploads/links',
                '../uploads/socials'
            ];
            
            foreach ($upload_dirs as $dir) {
                if (!file_exists($dir)) {
                    if (!mkdir($dir, 0755, true)) {
                        $success = false;
                        $errors[] = "Erro ao criar diretório: $dir";
                    }
                }
            }
            
            // Exibir mensagem de sucesso ou erro
            if ($success) {
                $message = '<div class="success">
                    <p>Atualização concluída com sucesso!</p>
                    <ul>
                        <li>' . ($links_column_exists ? 'Coluna image_url já existia na tabela links' : 'Coluna image_url adicionada à tabela links') . '</li>
                        <li>' . ($socials_column_exists ? 'Coluna custom_icon_url já existia na tabela socials' : 'Coluna custom_icon_url adicionada à tabela socials') . '</li>
                        <li>Diretórios para uploads verificados/criados</li>
                    </ul>
                </div>';
            } else {
                $message = '<div class="error">
                    <p>Ocorreram erros durante a atualização:</p>
                    <ul>';
                foreach ($errors as $error) {
                    $message .= '<li>' . $error . '</li>';
                }
                $message .= '</ul>
                </div>';
            }
            
            $conn->close();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atualizar Recursos da Página Bio</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        h1 {
            color: #6d28d9;
            text-align: center;
        }
        .container {
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 20px;
            margin-top: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="password"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            background-color: #6d28d9;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background-color: #5b21b6;
        }
        .success {
            background-color: #d1fae5;
            border: 1px solid #10b981;
            color: #047857;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .error {
            background-color: #fee2e2;
            border: 1px solid #ef4444;
            color: #b91c1c;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .info {
            background-color: #e0f2fe;
            border: 1px solid #0ea5e9;
            color: #0369a1;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .warning {
            background-color: #fffbeb;
            border: 1px solid #f59e0b;
            color: #b45309;
            padding: 10px;
            border-radius: 4px;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <h1>Atualizar Recursos da Página Bio</h1>
    
    <div class="container">
        <div class="info">
            Este script irá atualizar o banco de dados para adicionar suporte a:
            <ul>
                <li>Miniaturas de fotos nos links da bio</li>
                <li>Ícones personalizados nas redes sociais</li>
            </ul>
        </div>
        
        <div class="warning">
            <strong>IMPORTANTE:</strong> Por segurança, exclua este arquivo do servidor após utilizá-lo!
        </div>
        
        <?php echo $message; ?>
        
        <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
            <div class="form-group">
                <label for="security_password">Senha de Segurança:</label>
                <input type="password" id="security_password" name="security_password" required>
                <small>A senha de segurança padrão é: <strong>atualizar123</strong></small>
            </div>
            
            <button type="submit">Atualizar Recursos</button>
        </form>
    </div>
    
    <div class="container" style="margin-top: 20px;">
        <h3>Instruções:</h3>
        <ol>
            <li>Edite este arquivo para configurar corretamente a conexão com o banco de dados (linhas 6-8).</li>
            <li>Altere a senha de segurança (linha 22) para evitar uso não autorizado.</li>
            <li>Faça upload deste arquivo para a raiz do seu site.</li>
            <li>Acesse o arquivo pelo navegador: <code>https://seudominio.com.br/teste/update_features.php</code></li>
            <li>Digite a senha de segurança e clique em "Atualizar Recursos".</li>
            <li>Após a atualização bem-sucedida, <strong>exclua este arquivo do servidor</strong>.</li>
            <li>Faça login no painel administrativo para começar a usar os novos recursos.</li>
        </ol>
    </div>
</body>
</html>
