-- Criação da tabela de usuários
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    is_admin TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Criação da tabela de links
CREATE TABLE links (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(100) NOT NULL,
    url VARCHAR(255) NOT NULL,
    icon VARCHAR(50) DEFAULT 'link',
    order_position INT DEFAULT 0,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Criação da tabela de banners
CREATE TABLE banners (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(100) NOT NULL,
    image_url VARCHAR(255) NOT NULL,
    link_url VARCHAR(255) NOT NULL,
    order_position INT DEFAULT 0,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Criação da tabela de redes sociais
CREATE TABLE socials (
    id INT AUTO_INCREMENT PRIMARY KEY,
    platform VARCHAR(50) NOT NULL,
    url VARCHAR(255) NOT NULL,
    icon VARCHAR(50) NOT NULL,
    order_position INT DEFAULT 0,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Inserção de dados iniciais para usuário admin
INSERT INTO users (username, password, is_admin) VALUES ('admin', '$2y$10$8tGIx5g5xLlJzgD5Nj8KXOUgK/6QQRQiNUFJ6/TUbfkz4dzMnE.Oe', 1);
-- Senha: admin123 (hash bcrypt)

-- Inserção de dados iniciais para links
INSERT INTO links (title, url, icon, order_position, is_active) VALUES 
('Canal do YouTube', 'https://youtube.com/renanpeterlini', '🎬', 1, 1),
('Grupo VIP Telegram', 'https://t.me/renanpeterlini', '💬', 2, 1),
('Curso de Poker', 'https://curso.renanpeterlini.com.br', '🃏', 3, 1),
('Parceria 1GO Casino', 'https://1go.casino/renanpeterlini', '🎰', 4, 1);

-- Inserção de dados iniciais para banners
INSERT INTO banners (title, image_url, link_url, order_position, is_active) VALUES 
('Promoção 1GO Casino', 'uploads/banners/banner-1.jpg', 'https://1go.casino/renanpeterlini', 1, 1),
('Curso de Poker', 'uploads/banners/banner-2.jpg', 'https://curso.renanpeterlini.com.br', 2, 1),
('Grupo VIP', 'uploads/banners/banner-3.jpg', 'https://t.me/renanpeterlini', 3, 0);

-- Inserção de dados iniciais para redes sociais
INSERT INTO socials (platform, url, icon, order_position, is_active) VALUES 
('YouTube', 'https://youtube.com/renanpeterlini', '🎬', 1, 1),
('Instagram', 'https://instagram.com/rpeterlinioficial', '📸', 2, 1),
('Telegram', 'https://t.me/renanpeterlini', '📱', 3, 1),
('Twitter', 'https://twitter.com/renanpeterlini', '🐦', 4, 0);
