<?php
// Script para atualizar o banco de dados e adicionar suporte à personalização de cores e background
// Salve este arquivo como update_theme_settings.php na raiz do seu site

// Configurações de conexão com o banco de dados
$db_host = 'localhost';
$db_user = 'renanpet_renanbd'; // Altere para o seu usuário do banco de dados
$db_pass = '271217Ra@!';   // Altere para a sua senha do banco de dados
$db_name = 'renanpet_BD_BIO'; // Altere para o nome do seu banco de dados

// Mensagem de status
$message = '';

// Processar o formulário quando enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verificar se a senha de segurança está correta
    $security_password = $_POST['security_password'] ?? '';
    
    if ($security_password !== 'atualizar123') { // Altere esta senha de segurança!
        $message = '<div class="error">Senha de segurança incorreta!</div>';
    } else {
        // Conectar ao banco de dados
        $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
        
        // Verificar conexão
        if ($conn->connect_error) {
            $message = '<div class="error">Falha na conexão com o banco de dados: ' . $conn->connect_error . '</div>';
        } else {
            // Verificar se a tabela settings já existe
            $check_table = $conn->query("SHOW TABLES LIKE 'settings'");
            $table_exists = $check_table->num_rows > 0;
            
            $success = true;
            $errors = [];
            
            // Criar tabela settings se não existir
            if (!$table_exists) {
                $create_table = "CREATE TABLE settings (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    setting_key VARCHAR(50) NOT NULL UNIQUE,
                    setting_value TEXT,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
                )";
                
                if (!$conn->query($create_table)) {
                    $success = false;
                    $errors[] = "Erro ao criar tabela settings: " . $conn->error;
                } else {
                    $table_exists = true;
                }
            }
            
            // Inserir configurações padrão para cores e background
            if ($table_exists) {
                $theme_settings = [
                    ['primary_color', '#6d28d9'],
                    ['secondary_color', '#1e1e1e'],
                    ['text_color', '#f3f4f6'],
                    ['accent_color', '#8b5cf6'],
                    ['background_type', 'color'],
                    ['background_color', '#121212'],
                    ['background_image', '']
                ];
                
                foreach ($theme_settings as $setting) {
                    $key = $setting[0];
                    $value = $setting[1];
                    
                    // Verificar se a configuração já existe
                    $check_setting = $conn->prepare("SELECT id FROM settings WHERE setting_key = ?");
                    $check_setting->bind_param("s", $key);
                    $check_setting->execute();
                    $check_result = $check_setting->get_result();
                    
                    if ($check_result->num_rows > 0) {
                        // Atualizar configuração existente
                        $update_stmt = $conn->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
                        $update_stmt->bind_param("ss", $value, $key);
                        
                        if (!$update_stmt->execute()) {
                            $success = false;
                            $errors[] = "Erro ao atualizar configuração $key: " . $conn->error;
                        }
                        
                        $update_stmt->close();
                    } else {
                        // Inserir nova configuração
                        $insert_stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?)");
                        $insert_stmt->bind_param("ss", $key, $value);
                        
                        if (!$insert_stmt->execute()) {
                            $success = false;
                            $errors[] = "Erro ao inserir configuração $key: " . $conn->error;
                        }
                        
                        $insert_stmt->close();
                    }
                    
                    $check_setting->close();
                }
            }
            
            // Criar diretório para uploads de imagens de background se não existir
            $upload_dir = '../uploads/background';
            if (!file_exists($upload_dir)) {
                if (!mkdir($upload_dir, 0755, true)) {
                    $success = false;
                    $errors[] = "Erro ao criar diretório: $upload_dir";
                }
            }
            
            // Exibir mensagem de sucesso ou erro
            if ($success) {
                $message = '<div class="success">
                    <p>Atualização concluída com sucesso!</p>
                    <ul>
                        <li>' . ($table_exists ? 'Tabela settings já existia' : 'Tabela settings criada com sucesso') . '</li>
                        <li>Configurações de cores e background adicionadas/atualizadas</li>
                        <li>Diretório para uploads de imagens de background verificado/criado</li>
                    </ul>
                </div>';
            } else {
                $message = '<div class="error">
                    <p>Ocorreram erros durante a atualização:</p>
                    <ul>';
                foreach ($errors as $error) {
                    $message .= '<li>' . $error . '</li>';
                }
                $message .= '</ul>
                </div>';
            }
            
            $conn->close();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atualizar Configurações de Tema</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        h1 {
            color: #6d28d9;
            text-align: center;
        }
        .container {
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 20px;
            margin-top: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="password"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            background-color: #6d28d9;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background-color: #5b21b6;
        }
        .success {
            background-color: #d1fae5;
            border: 1px solid #10b981;
            color: #047857;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .error {
            background-color: #fee2e2;
            border: 1px solid #ef4444;
            color: #b91c1c;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .info {
            background-color: #e0f2fe;
            border: 1px solid #0ea5e9;
            color: #0369a1;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .warning {
            background-color: #fffbeb;
            border: 1px solid #f59e0b;
            color: #b45309;
            padding: 10px;
            border-radius: 4px;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <h1>Atualizar Configurações de Tema</h1>
    
    <div class="container">
        <div class="info">
            Este script irá atualizar o banco de dados para adicionar suporte à personalização de cores e background:
            <ul>
                <li>Criar/verificar tabela de configurações</li>
                <li>Adicionar configurações padrão para cores e background</li>
                <li>Criar diretório para uploads de imagens de background</li>
            </ul>
        </div>
        
        <div class="warning">
            <strong>IMPORTANTE:</strong> Por segurança, exclua este arquivo do servidor após utilizá-lo!
        </div>
        
        <?php echo $message; ?>
        
        <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
            <div class="form-group">
                <label for="security_password">Senha de Segurança:</label>
                <input type="password" id="security_password" name="security_password" required>
                <small>A senha de segurança padrão é: <strong>atualizar123</strong></small>
            </div>
            
            <button type="submit">Atualizar Banco de Dados</button>
        </form>
    </div>
    
    <div class="container" style="margin-top: 20px;">
        <h3>Instruções:</h3>
        <ol>
            <li>Edite este arquivo para configurar corretamente a conexão com o banco de dados (linhas 6-8).</li>
            <li>Altere a senha de segurança (linha 22) para evitar uso não autorizado.</li>
            <li>Faça upload deste arquivo para a raiz do seu site.</li>
            <li>Acesse o arquivo pelo navegador: <code>https://seudominio.com.br/teste/update_theme_settings.php</code></li>
            <li>Digite a senha de segurança e clique em "Atualizar Banco de Dados".</li>
            <li>Após a atualização bem-sucedida, <strong>exclua este arquivo do servidor</strong>.</li>
            <li>Faça upload dos arquivos atualizados para adicionar a funcionalidade de personalização de tema.</li>
        </ol>
    </div>
</body>
</html>
