<?php
// Script para atualizar o banco de dados e adicionar suporte a métricas de acesso
// Salve este arquivo como update_metrics_schema.php na raiz do seu site

// Configurações de conexão com o banco de dados
$db_host = 'localhost';
$db_user = 'seu_usuario'; // Altere para o seu usuário do banco de dados
$db_pass = 'sua_senha';   // Altere para a sua senha do banco de dados
$db_name = 'renanpeterlini'; // Altere para o nome do seu banco de dados

// Mensagem de status
$message = '';

// Processar o formulário quando enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verificar se a senha de segurança está correta
    $security_password = $_POST['security_password'] ?? '';
    
    if ($security_password !== 'atualizar123') { // Altere esta senha de segurança!
        $message = '<div class="error">Senha de segurança incorreta!</div>';
    } else {
        // Conectar ao banco de dados
        $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
        
        // Verificar conexão
        if ($conn->connect_error) {
            $message = '<div class="error">Falha na conexão com o banco de dados: ' . $conn->connect_error . '</div>';
        } else {
            // Verificar se a tabela settings já existe
            $check_table = $conn->query("SHOW TABLES LIKE 'settings'");
            $table_exists = $check_table->num_rows > 0;
            
            $success = true;
            $errors = [];
            
            // Criar tabela settings se não existir
            if (!$table_exists) {
                $create_table = "CREATE TABLE settings (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    setting_key VARCHAR(50) NOT NULL UNIQUE,
                    setting_value TEXT,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
                )";
                
                if (!$conn->query($create_table)) {
                    $success = false;
                    $errors[] = "Erro ao criar tabela settings: " . $conn->error;
                } else {
                    $table_exists = true;
                }
            }
            
            // Criar tabela page_views
            $create_page_views = "CREATE TABLE IF NOT EXISTS page_views (
                id INT AUTO_INCREMENT PRIMARY KEY,
                visitor_ip VARCHAR(45) NOT NULL,
                visitor_user_agent TEXT,
                visitor_device_type ENUM('desktop', 'mobile', 'tablet', 'unknown') DEFAULT 'unknown',
                visitor_device_name VARCHAR(255),
                visitor_browser VARCHAR(100),
                visitor_os VARCHAR(100),
                visitor_country VARCHAR(100),
                visitor_region VARCHAR(100),
                visitor_city VARCHAR(100),
                visit_date DATETIME DEFAULT CURRENT_TIMESTAMP,
                session_id VARCHAR(255),
                referrer_url TEXT,
                INDEX (visit_date),
                INDEX (visitor_device_type),
                INDEX (visitor_country)
            )";
            
            if (!$conn->query($create_page_views)) {
                $success = false;
                $errors[] = "Erro ao criar tabela page_views: " . $conn->error;
            }
            
            // Criar tabela link_clicks
            $create_link_clicks = "CREATE TABLE IF NOT EXISTS link_clicks (
                id INT AUTO_INCREMENT PRIMARY KEY,
                link_id INT NOT NULL,
                visitor_ip VARCHAR(45) NOT NULL,
                visitor_device_type ENUM('desktop', 'mobile', 'tablet', 'unknown') DEFAULT 'unknown',
                visitor_country VARCHAR(100),
                visitor_region VARCHAR(100),
                session_id VARCHAR(255),
                click_date DATETIME DEFAULT CURRENT_TIMESTAMP,
                INDEX (link_id),
                INDEX (click_date),
                INDEX (visitor_device_type),
                INDEX (visitor_country),
                FOREIGN KEY (link_id) REFERENCES links(id) ON DELETE CASCADE
            )";
            
            if (!$conn->query($create_link_clicks)) {
                $success = false;
                $errors[] = "Erro ao criar tabela link_clicks: " . $conn->error;
            }
            
            // Criar tabela banner_clicks
            $create_banner_clicks = "CREATE TABLE IF NOT EXISTS banner_clicks (
                id INT AUTO_INCREMENT PRIMARY KEY,
                banner_id INT NOT NULL,
                visitor_ip VARCHAR(45) NOT NULL,
                visitor_device_type ENUM('desktop', 'mobile', 'tablet', 'unknown') DEFAULT 'unknown',
                visitor_country VARCHAR(100),
                visitor_region VARCHAR(100),
                session_id VARCHAR(255),
                click_date DATETIME DEFAULT CURRENT_TIMESTAMP,
                INDEX (banner_id),
                INDEX (click_date),
                INDEX (visitor_device_type),
                INDEX (visitor_country),
                FOREIGN KEY (banner_id) REFERENCES banners(id) ON DELETE CASCADE
            )";
            
            if (!$conn->query($create_banner_clicks)) {
                $success = false;
                $errors[] = "Erro ao criar tabela banner_clicks: " . $conn->error;
            }
            
            // Criar tabela social_clicks
            $create_social_clicks = "CREATE TABLE IF NOT EXISTS social_clicks (
                id INT AUTO_INCREMENT PRIMARY KEY,
                social_id INT NOT NULL,
                visitor_ip VARCHAR(45) NOT NULL,
                visitor_device_type ENUM('desktop', 'mobile', 'tablet', 'unknown') DEFAULT 'unknown',
                visitor_country VARCHAR(100),
                visitor_region VARCHAR(100),
                session_id VARCHAR(255),
                click_date DATETIME DEFAULT CURRENT_TIMESTAMP,
                INDEX (social_id),
                INDEX (click_date),
                INDEX (visitor_device_type),
                INDEX (visitor_country),
                FOREIGN KEY (social_id) REFERENCES socials(id) ON DELETE CASCADE
            )";
            
            if (!$conn->query($create_social_clicks)) {
                $success = false;
                $errors[] = "Erro ao criar tabela social_clicks: " . $conn->error;
            }
            
            // Adicionar configurações para API do YouTube
            if ($table_exists) {
                $youtube_settings = [
                    ['youtube_channel_id', 'UClwDfAjI19NwR2hX5uHS4Cg'],
                    ['youtube_api_key', '']
                ];
                
                foreach ($youtube_settings as $setting) {
                    $key = $setting[0];
                    $value = $setting[1];
                    
                    // Verificar se a configuração já existe
                    $check_setting = $conn->prepare("SELECT id FROM settings WHERE setting_key = ?");
                    $check_setting->bind_param("s", $key);
                    $check_setting->execute();
                    $check_result = $check_setting->get_result();
                    
                    if ($check_result->num_rows > 0) {
                        // Atualizar configuração existente
                        $update_stmt = $conn->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
                        $update_stmt->bind_param("ss", $value, $key);
                        
                        if (!$update_stmt->execute()) {
                            $success = false;
                            $errors[] = "Erro ao atualizar configuração $key: " . $conn->error;
                        }
                        
                        $update_stmt->close();
                    } else {
                        // Inserir nova configuração
                        $insert_stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?)");
                        $insert_stmt->bind_param("ss", $key, $value);
                        
                        if (!$insert_stmt->execute()) {
                            $success = false;
                            $errors[] = "Erro ao inserir configuração $key: " . $conn->error;
                        }
                        
                        $insert_stmt->close();
                    }
                    
                    $check_setting->close();
                }
            }
            
            // Exibir mensagem de sucesso ou erro
            if ($success) {
                $message = '<div class="success">
                    <p>Atualização concluída com sucesso!</p>
                    <ul>
                        <li>Tabela page_views criada/verificada</li>
                        <li>Tabela link_clicks criada/verificada</li>
                        <li>Tabela banner_clicks criada/verificada</li>
                        <li>Tabela social_clicks criada/verificada</li>
                        <li>Configurações para API do YouTube adicionadas/atualizadas</li>
                    </ul>
                </div>';
            } else {
                $message = '<div class="error">
                    <p>Ocorreram erros durante a atualização:</p>
                    <ul>';
                foreach ($errors as $error) {
                    $message .= '<li>' . $error . '</li>';
                }
                $message .= '</ul>
                </div>';
            }
            
            $conn->close();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atualizar Esquema de Métricas</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        h1 {
            color: #6d28d9;
            text-align: center;
        }
        .container {
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 20px;
            margin-top: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="password"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            background-color: #6d28d9;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background-color: #5b21b6;
        }
        .success {
            background-color: #d1fae5;
            border: 1px solid #10b981;
            color: #047857;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .error {
            background-color: #fee2e2;
            border: 1px solid #ef4444;
            color: #b91c1c;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .info {
            background-color: #e0f2fe;
            border: 1px solid #0ea5e9;
            color: #0369a1;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .warning {
            background-color: #fffbeb;
            border: 1px solid #f59e0b;
            color: #b45309;
            padding: 10px;
            border-radius: 4px;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <h1>Atualizar Esquema de Métricas</h1>
    
    <div class="container">
        <div class="info">
            Este script irá atualizar o banco de dados para adicionar suporte a métricas de acesso:
            <ul>
                <li>Criar tabelas para armazenar visualizações de página</li>
                <li>Criar tabelas para armazenar cliques em links</li>
                <li>Criar tabelas para armazenar cliques em banners</li>
                <li>Criar tabelas para armazenar cliques em redes sociais</li>
                <li>Adicionar configurações para API do YouTube</li>
            </ul>
        </div>
        
        <div class="warning">
            <strong>IMPORTANTE:</strong> Por segurança, exclua este arquivo do servidor após utilizá-lo!
        </div>
        
        <?php echo $message; ?>
        
        <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
            <div class="form-group">
                <label for="security_password">Senha de Segurança:</label>
                <input type="password" id="security_password" name="security_password" required>
                <small>A senha de segurança padrão é: <strong>atualizar123</strong></small>
            </div>
            
            <button type="submit">Atualizar Banco de Dados</button>
        </form>
    </div>
    
    <div class="container" style="margin-top: 20px;">
        <h3>Instruções:</h3>
        <ol>
            <li>Edite este arquivo para configurar corretamente a conexão com o banco de dados (linhas 6-8).</li>
            <li>Altere a senha de segurança (linha 22) para evitar uso não autorizado.</li>
            <li>Faça upload deste arquivo para a raiz do seu site.</li>
            <li>Acesse o arquivo pelo navegador: <code>https://seudominio.com.br/teste/update_metrics_schema.php</code></li>
            <li>Digite a senha de segurança e clique em "Atualizar Banco de Dados".</li>
            <li>Após a atualização bem-sucedida, <strong>exclua este arquivo do servidor</strong>.</li>
            <li>Faça upload dos arquivos atualizados para adicionar a funcionalidade de métricas.</li>
        </ol>
    </div>
</body>
</html>
