<?php
// Script de redefinição de senha para o painel administrativo
// Salve este arquivo como reset_password.php na raiz do seu site

// Configurações de conexão com o banco de dados
$db_host = 'localhost';
$db_user = 'renanpet_renanbd'; // Altere para o seu usuário do banco de dados
$db_pass = '271217Ra@!';   // Altere para a sua senha do banco de dados
$db_name = 'renanpet_BD_BIO'; // Altere para o nome do seu banco de dados

// Senha padrão que você deseja definir
$new_username = 'admin';
$new_password = 'admin123';

// Mensagem de status
$message = '';

// Processar o formulário quando enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verificar se a senha de segurança está correta
    $security_password = $_POST['security_password'] ?? '';
    
    if ($security_password !== 'redefinir123') { // Altere esta senha de segurança!
        $message = '<div class="error">Senha de segurança incorreta!</div>';
    } else {
        // Conectar ao banco de dados
        $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
        
        // Verificar conexão
        if ($conn->connect_error) {
            $message = '<div class="error">Falha na conexão com o banco de dados: ' . $conn->connect_error . '</div>';
        } else {
            // Gerar hash da nova senha
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            
            // Verificar se o usuário existe
            $check_sql = "SELECT id FROM users WHERE username = ?";
            $check_stmt = $conn->prepare($check_sql);
            $check_stmt->bind_param("s", $new_username);
            $check_stmt->execute();
            $check_result = $check_stmt->get_result();
            
            if ($check_result->num_rows > 0) {
                // Atualizar senha do usuário existente
                $user = $check_result->fetch_assoc();
                $update_sql = "UPDATE users SET password = ? WHERE id = ?";
                $update_stmt = $conn->prepare($update_sql);
                $update_stmt->bind_param("si", $hashed_password, $user['id']);
                
                if ($update_stmt->execute()) {
                    $message = '<div class="success">Senha redefinida com sucesso para o usuário: ' . htmlspecialchars($new_username) . '</div>';
                } else {
                    $message = '<div class="error">Erro ao redefinir a senha: ' . $conn->error . '</div>';
                }
                
                $update_stmt->close();
            } else {
                // Criar novo usuário admin
                $insert_sql = "INSERT INTO users (username, password, is_admin) VALUES (?, ?, 1)";
                $insert_stmt = $conn->prepare($insert_sql);
                $insert_stmt->bind_param("ss", $new_username, $hashed_password);
                
                if ($insert_stmt->execute()) {
                    $message = '<div class="success">Novo usuário admin criado com sucesso: ' . htmlspecialchars($new_username) . '</div>';
                } else {
                    $message = '<div class="error">Erro ao criar novo usuário: ' . $conn->error . '</div>';
                }
                
                $insert_stmt->close();
            }
            
            $check_stmt->close();
            $conn->close();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Redefinir Senha de Administrador</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        h1 {
            color: #6d28d9;
            text-align: center;
        }
        .container {
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 20px;
            margin-top: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="password"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            background-color: #6d28d9;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background-color: #5b21b6;
        }
        .success {
            background-color: #d1fae5;
            border: 1px solid #10b981;
            color: #047857;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .error {
            background-color: #fee2e2;
            border: 1px solid #ef4444;
            color: #b91c1c;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .info {
            background-color: #e0f2fe;
            border: 1px solid #0ea5e9;
            color: #0369a1;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .warning {
            background-color: #fffbeb;
            border: 1px solid #f59e0b;
            color: #b45309;
            padding: 10px;
            border-radius: 4px;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <h1>Redefinir Senha de Administrador</h1>
    
    <div class="container">
        <div class="info">
            Este script irá redefinir a senha do usuário administrador para <strong><?php echo htmlspecialchars($new_username); ?></strong> com a senha <strong><?php echo htmlspecialchars($new_password); ?></strong>.
        </div>
        
        <div class="warning">
            <strong>IMPORTANTE:</strong> Por segurança, exclua este arquivo do servidor após utilizá-lo!
        </div>
        
        <?php echo $message; ?>
        
        <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
            <div class="form-group">
                <label for="security_password">Senha de Segurança:</label>
                <input type="password" id="security_password" name="security_password" required>
                <small>A senha de segurança padrão é: <strong>redefinir123</strong></small>
            </div>
            
            <button type="submit">Redefinir Senha</button>
        </form>
    </div>
    
    <div class="container" style="margin-top: 20px;">
        <h3>Instruções:</h3>
        <ol>
            <li>Edite este arquivo para configurar corretamente a conexão com o banco de dados (linhas 6-8).</li>
            <li>Se desejar, altere o nome de usuário e senha padrão (linhas 11-12).</li>
            <li>Altere a senha de segurança (linha 22) para evitar uso não autorizado.</li>
            <li>Faça upload deste arquivo para a raiz do seu site.</li>
            <li>Acesse o arquivo pelo navegador: <code>https://seudominio.com.br/teste/reset_password.php</code></li>
            <li>Digite a senha de segurança e clique em "Redefinir Senha".</li>
            <li>Após redefinir a senha com sucesso, <strong>exclua este arquivo do servidor</strong>.</li>
            <li>Faça login no painel administrativo com as novas credenciais.</li>
        </ol>
    </div>
</body>
</html>
