# Instruções de Instalação - Página Bio Renan Peterlini

Este documento contém as instruções para instalar a página bio de Renan Peterlini em um servidor de hospedagem compartilhada com PHP e MySQL.

## Requisitos do Servidor

- PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Suporte a uploads de arquivos
- Permissões de escrita na pasta `uploads`

## Passos para Instalação

### 1. Fazer Upload dos Arquivos

1. Faça login no seu painel de controle de hospedagem
2. Navegue até o gerenciador de arquivos
3. Acesse a pasta `public_html` ou a pasta raiz do seu domínio
4. Crie uma pasta chamada `teste` (ou outro nome de sua preferência)
5. Faça upload de todos os arquivos deste pacote para a pasta criada

### 2. Criar o Banco de Dados

1. Acesse o painel de controle da sua hospedagem
2. Localize a seção "Bancos de Dados" ou "MySQL"
3. Crie um novo banco de dados (anote o nome)
4. Crie um novo usuário para o banco de dados (anote o nome de usuário e senha)
5. Atribua todas as permissões ao usuário para o banco de dados criado

### 3. Importar a Estrutura do Banco de Dados

1. Acesse o phpMyAdmin através do painel de controle da sua hospedagem
2. Selecione o banco de dados que você criou
3. Clique na aba "Importar"
4. Clique em "Escolher arquivo" e selecione o arquivo `database.sql` deste pacote
5. Clique em "Executar" para importar a estrutura e os dados iniciais

### 4. Configurar a Conexão com o Banco de Dados

1. Abra o arquivo `config.php` em um editor de texto
2. Localize as seguintes linhas:
   ```php
   $db_host = 'localhost';
   $db_user = 'seu_usuario';
   $db_pass = 'sua_senha';
   $db_name = 'renanpeterlini';
   ```
3. Substitua `'seu_usuario'` pelo nome de usuário do banco de dados que você criou
4. Substitua `'sua_senha'` pela senha do usuário do banco de dados
5. Substitua `'renanpeterlini'` pelo nome do banco de dados que você criou
6. Salve o arquivo e faça upload novamente para o servidor

### 5. Criar Diretórios de Upload

1. Acesse a pasta onde você fez upload dos arquivos
2. Crie uma pasta chamada `uploads` (se não existir)
3. Dentro da pasta `uploads`, crie uma pasta chamada `banners`
4. Certifique-se de que as permissões das pastas estejam configuradas para 755 (ou 775)

### 6. Acessar a Página

1. Abra seu navegador e acesse `https://seudominio.com.br/teste/` (substitua pelo caminho correto)
2. Você deverá ver a página bio com os links, banners e redes sociais de exemplo

### 7. Acessar o Painel Administrativo

1. Acesse `https://seudominio.com.br/teste/login.php`
2. Use as credenciais padrão:
   - Usuário: `admin`
   - Senha: `admin123`
3. Após o primeiro login, é altamente recomendável alterar a senha padrão

## Alterando a Senha de Administrador

Para alterar a senha do administrador, você pode:

1. Acessar o phpMyAdmin
2. Selecionar o banco de dados da aplicação
3. Selecionar a tabela `users`
4. Executar a seguinte consulta SQL:

```sql
UPDATE users SET password = '$2y$10$novasenhahasheada' WHERE username = 'admin';
```

Ou, para maior segurança, você pode criar um novo usuário administrador:

```sql
INSERT INTO users (username, password, is_admin) VALUES ('seu_novo_usuario', '$2y$10$senhahasheada', 1);
```

## Estrutura de Arquivos

- `index.php` - Página principal (bio)
- `login.php` - Página de login para o painel administrativo
- `config.php` - Configurações de conexão com o banco de dados
- `database.sql` - Estrutura e dados iniciais do banco de dados
- `admin/` - Pasta com os arquivos do painel administrativo
  - `index.php` - Dashboard do painel
  - `links.php` - Gerenciamento de links
  - `banners.php` - Gerenciamento de banners
  - `socials.php` - Gerenciamento de redes sociais
  - `sidebar.php` - Barra lateral do painel
  - `logout.php` - Script para sair do painel
- `uploads/` - Pasta para armazenar arquivos enviados
  - `banners/` - Pasta para armazenar imagens de banners

## Solução de Problemas

### Erro de Conexão com o Banco de Dados

- Verifique se as credenciais no arquivo `config.php` estão corretas
- Confirme se o banco de dados foi criado corretamente
- Verifique se o usuário tem permissões para acessar o banco de dados

### Erro ao Fazer Upload de Imagens

- Verifique se a pasta `uploads/banners` existe e tem permissões de escrita (755 ou 775)
- Confirme se o tamanho do arquivo não excede o limite permitido pelo servidor
- Verifique se o tipo de arquivo é permitido (JPG, PNG, GIF, etc.)

### Página em Branco ou Erro 500

- Verifique os logs de erro do servidor
- Confirme se a versão do PHP é compatível (7.4+)
- Verifique se todas as extensões necessárias do PHP estão habilitadas

## Suporte

Em caso de problemas durante a instalação, entre em contato com o desenvolvedor responsável.
