<?php
require_once 'config.php';
require_once 'multi_banners.php';

// Obter links ativos
$sql = "SELECT * FROM links WHERE is_active = 1 ORDER BY order_position ASC";
$links_result = $conn->query($sql);

// Obter banners ativos (até 3)
$banners = getActiveBanners($conn, 3);

// Obter redes sociais ativas
$sql = "SELECT * FROM socials WHERE is_active = 1 ORDER BY order_position ASC";
$socials_result = $conn->query($sql);

// Obter foto de perfil
$profile_photo = '';
$profile_name = 'Renan Peterlini';
$profile_description = 'Jogador de Poker, entusiasta das apostas';

$sql = "SELECT setting_value FROM settings WHERE setting_key = 'profile_photo'";
$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $profile_photo = $row['setting_value'];
}

// Obter configurações de tema
$theme = [
    'primary_color' => '#6d28d9',
    'secondary_color' => '#1e1e1e',
    'text_color' => '#f3f4f6',
    'accent_color' => '#8b5cf6',
    'background_type' => 'color',
    'background_color' => '#121212',
    'background_image' => ''
];

$sql = "SELECT setting_key, setting_value FROM settings WHERE setting_key IN 
        ('primary_color', 'secondary_color', 'text_color', 'accent_color', 
         'background_type', 'background_color', 'background_image')";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $theme[$row['setting_key']] = $row['setting_value'];
    }
}

// Obter o último vídeo do YouTube
$latest_video = getLatestYoutubeVideo($conn);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Renan Peterlini</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        :root {
            --color-dark: <?php echo $theme['secondary_color']; ?>;
            --color-secondary: <?php echo $theme['secondary_color']; ?>;
            --color-primary: <?php echo $theme['primary_color']; ?>;
            --color-accent: <?php echo $theme['accent_color']; ?>;
            --color-light: <?php echo $theme['text_color']; ?>;
        }
        body {
            <?php if ($theme['background_type'] === 'color'): ?>
            background-color: <?php echo $theme['background_color']; ?>;
            <?php else: ?>
            background-color: #121212; /* Fallback color */
            <?php endif; ?>
            
            <?php if ($theme['background_type'] === 'image' && !empty($theme['background_image'])): ?>
            background-image: url('<?php echo $theme['background_image']; ?>');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            <?php endif; ?>
            
            color: var(--color-light);
            font-family: 'Inter', sans-serif;
        }
        .container-custom {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
        }
        .bg-dark {
            background-color: var(--color-dark);
        }
        .bg-secondary {
            background-color: var(--color-secondary);
        }
        .bg-primary {
            background-color: var(--color-primary);
        }
        .text-light {
            color: var(--color-light);
        }
        .text-accent {
            color: var(--color-accent);
        }
        .shadow-custom {
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .link-card {
            display: block;
            padding: 1rem;
            background-color: var(--color-secondary);
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }
        .link-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .social-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 3rem;
            height: 3rem;
            background-color: var(--color-primary);
            border-radius: 9999px;
            transition: all 0.3s ease;
        }
        .social-icon:hover {
            background-color: var(--color-accent);
            transform: scale(1.1);
        }
        .profile-photo {
            width: 96px;
            height: 96px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--color-accent);
        }
        .content-wrapper {
            <?php if ($theme['background_type'] === 'image'): ?>
            background-color: rgba(0, 0, 0, 0.7);
            backdrop-filter: blur(5px);
            border-radius: 1rem;
            margin: 1rem 0;
            padding: 1rem;
            <?php endif; ?>
        }
        .banner-section {
            margin-bottom: 2.5rem;
        }
        .youtube-section {
            margin-bottom: 2.5rem;
        }
    </style>
</head>
<body>
    <header class="py-6 bg-secondary">
        <div class="container-custom">
            <div class="flex flex-col items-center justify-center">
                <?php if (!empty($profile_photo)): ?>
                    <img 
                        src="<?php echo htmlspecialchars($profile_photo); ?>" 
                        alt="<?php echo htmlspecialchars($profile_name); ?>" 
                        class="profile-photo mb-4"
                        onerror="this.src='https://via.placeholder.com/96x96?text=RP'"
                    >
                <?php else: ?>
                    <div class="w-24 h-24 rounded-full bg-primary flex items-center justify-center mb-4 text-3xl">
                        👤
                    </div>
                <?php endif; ?>
                <h1 class="text-2xl font-bold text-light"><?php echo htmlspecialchars($profile_name); ?></h1>
                <p class="text-gray-400"><?php echo htmlspecialchars($profile_description); ?></p>
            </div>
        </div>
    </header>

    <main class="container-custom py-8">
        <div class="content-wrapper">
            <!-- Banner Section -->
            <section class="banner-section">
                <?php echo displayMultiBanners($banners); ?>
            </section>

            <!-- YouTube Section -->
            <section class="youtube-section">
                <h2 class="text-xl font-semibold text-light mb-4">Último Vídeo</h2>
                <?php echo displayLatestYoutubeVideo($latest_video); ?>
            </section>

            <!-- Links Section -->
            <section class="mb-10">
                <h2 class="text-xl font-semibold text-light mb-4">Links</h2>
                <div class="space-y-3">
                    <?php if ($links_result->num_rows > 0): ?>
                        <?php while($link = $links_result->fetch_assoc()): ?>
                            <a 
                                href="<?php echo htmlspecialchars($link['url']); ?>" 
                                target="_blank"
                                class="link-card"
                                data-link-id="<?php echo $link['id']; ?>"
                            >
                                <div class="flex items-center w-full">
                                    <?php if (!empty($link['image_url'])): ?>
                                        <div class="w-12 h-12 rounded-lg overflow-hidden mr-4 bg-gray-800 flex-shrink-0">
                                            <img 
                                                src="<?php echo htmlspecialchars($link['image_url']); ?>" 
                                                alt="<?php echo htmlspecialchars($link['title']); ?>" 
                                                class="w-full h-full object-cover"
                                                onerror="this.parentNode.innerHTML='<div class=\'w-10 h-10 rounded-full bg-primary flex items-center justify-center\'><span class=\'text-white\'><?php echo htmlspecialchars($link['icon']); ?></span></div>'"
                                            >
                                        </div>
                                    <?php else: ?>
                                        <div class="w-10 h-10 rounded-full bg-primary flex items-center justify-center mr-4">
                                            <span class="text-white"><?php echo htmlspecialchars($link['icon']); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <span class="text-light"><?php echo htmlspecialchars($link['title']); ?></span>
                                </div>
                            </a>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <p class="text-gray-400 text-center">Nenhum link disponível no momento.</p>
                    <?php endif; ?>
                </div>
            </section>

            <!-- Social Media Section -->
            <section class="mb-10">
                <h2 class="text-xl font-semibold text-light mb-4">Redes Sociais</h2>
                <div class="flex flex-wrap gap-4">
                    <?php if ($socials_result->num_rows > 0): ?>
                        <?php while($social = $socials_result->fetch_assoc()): ?>
                            <a 
                                href="<?php echo htmlspecialchars($social['url']); ?>" 
                                target="_blank"
                                class="social-icon"
                                title="<?php echo htmlspecialchars($social['platform']); ?>"
                                data-social-id="<?php echo $social['id']; ?>"
                            >
                                <?php if (!empty($social['custom_icon_url'])): ?>
                                    <img 
                                        src="<?php echo htmlspecialchars($social['custom_icon_url']); ?>" 
                                        alt="<?php echo htmlspecialchars($social['platform']); ?>" 
                                        class="w-5 h-5 object-contain"
                                        onerror="this.parentNode.innerHTML='<span class=\'text-white\'><?php echo htmlspecialchars($social['icon']); ?></span>'"
                                    >
                                <?php else: ?>
                                    <span class="text-white"><?php echo htmlspecialchars($social['icon']); ?></span>
                                <?php endif; ?>
                            </a>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <p class="text-gray-400 text-center w-full"></p>
                    <?php endif; ?>
                </div>
            </section>
        </div>
    </main>

    <footer class="py-6 bg-secondary">
        <div class="container-custom text-center">
            <p class="text-gray-400">© <?php echo date('Y'); ?> <b>+18</b> Aposta não é investimento - Jogue com Responsabilidade. <b>Renan Peterlini</b> Todos os direitos reservados.</p>
        </div>
    </footer>

    <?php echo getTrackingScript(); ?>
</body>
</html>
