<?php
require_once '../config.php';

// Verificar se o usuário está logado
if (!isLoggedIn()) {
    redirect('../login.php');
}

// Obter configurações atuais
$settings = [];
$sql = "SELECT setting_key, setting_value FROM settings WHERE setting_key IN 
        ('primary_color', 'secondary_color', 'text_color', 'accent_color', 
         'background_type', 'background_color', 'background_image')";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}

// Definir valores padrão se não existirem
$defaults = [
    'primary_color' => '#6d28d9',
    'secondary_color' => '#1e1e1e',
    'text_color' => '#f3f4f6',
    'accent_color' => '#8b5cf6',
    'background_type' => 'color',
    'background_color' => '#121212',
    'background_image' => ''
];

foreach ($defaults as $key => $value) {
    if (!isset($settings[$key])) {
        $settings[$key] = $value;
    }
}

// Processar formulário de atualização de tema
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $success = false;
    $error = '';
    
    // Obter valores do formulário
    $primary_color = $_POST['primary_color'] ?? $settings['primary_color'];
    $secondary_color = $_POST['secondary_color'] ?? $settings['secondary_color'];
    $text_color = $_POST['text_color'] ?? $settings['text_color'];
    $accent_color = $_POST['accent_color'] ?? $settings['accent_color'];
    $background_type = $_POST['background_type'] ?? $settings['background_type'];
    $background_color = $_POST['background_color'] ?? $settings['background_color'];
    $background_image = $settings['background_image']; // Valor padrão é o atual
    
    // Processar upload de imagem de background se fornecido
    if ($background_type === 'image' && isset($_FILES['background_image']) && $_FILES['background_image']['error'] === 0) {
        $uploadDir = '../uploads/background/';
        
        // Criar diretório se não existir
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        $fileName = basename($_FILES['background_image']['name']);
        $fileType = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        $newFileName = 'background-' . time() . '.' . $fileType;
        $targetFile = $uploadDir . $newFileName;
        
        // Verificar se é uma imagem real
        $check = getimagesize($_FILES['background_image']['tmp_name']);
        if ($check === false) {
            $error = 'O arquivo não é uma imagem válida.';
        }
        // Verificar o tamanho do arquivo (máximo 5MB)
        elseif ($_FILES['background_image']['size'] > 5000000) {
            $error = 'O arquivo é muito grande. Tamanho máximo: 5MB.';
        }
        // Permitir apenas certos formatos de arquivo
        elseif ($fileType != "jpg" && $fileType != "png" && $fileType != "jpeg" && $fileType != "gif" && $fileType != "webp") {
            $error = 'Apenas arquivos JPG, JPEG, PNG, GIF e WEBP são permitidos.';
        }
        // Fazer upload do arquivo
        elseif (move_uploaded_file($_FILES['background_image']['tmp_name'], $targetFile)) {
            $background_image = 'uploads/background/' . $newFileName;
            
            // Excluir a imagem antiga se existir
            if (!empty($settings['background_image']) && file_exists('../' . $settings['background_image'])) {
                unlink('../' . $settings['background_image']);
            }
        } else {
            $error = 'Ocorreu um erro ao fazer upload da imagem.';
        }
    }
    
    // Se não houver erros, atualizar as configurações
    if (empty($error)) {
        $update_settings = [
            ['primary_color', $primary_color],
            ['secondary_color', $secondary_color],
            ['text_color', $text_color],
            ['accent_color', $accent_color],
            ['background_type', $background_type],
            ['background_color', $background_color],
            ['background_image', $background_image]
        ];
        
        $all_success = true;
        
        foreach ($update_settings as $setting) {
            $key = $setting[0];
            $value = $setting[1];
            
            // Verificar se a configuração já existe
            $check_setting = $conn->prepare("SELECT id FROM settings WHERE setting_key = ?");
            $check_setting->bind_param("s", $key);
            $check_setting->execute();
            $check_result = $check_setting->get_result();
            
            if ($check_result->num_rows > 0) {
                // Atualizar configuração existente
                $update_stmt = $conn->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
                $update_stmt->bind_param("ss", $value, $key);
                
                if (!$update_stmt->execute()) {
                    $all_success = false;
                    $error = "Erro ao atualizar configuração $key: " . $conn->error;
                    break;
                }
                
                $update_stmt->close();
            } else {
                // Inserir nova configuração
                $insert_stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?)");
                $insert_stmt->bind_param("ss", $key, $value);
                
                if (!$insert_stmt->execute()) {
                    $all_success = false;
                    $error = "Erro ao inserir configuração $key: " . $conn->error;
                    break;
                }
                
                $insert_stmt->close();
            }
            
            $check_setting->close();
        }
        
        $success = $all_success;
        
        // Atualizar as configurações locais para exibição
        if ($success) {
            $settings['primary_color'] = $primary_color;
            $settings['secondary_color'] = $secondary_color;
            $settings['text_color'] = $text_color;
            $settings['accent_color'] = $accent_color;
            $settings['background_type'] = $background_type;
            $settings['background_color'] = $background_color;
            $settings['background_image'] = $background_image;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Personalização de Tema - Painel Administrativo</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        :root {
            --color-dark: <?php echo $settings['secondary_color']; ?>;
            --color-secondary: <?php echo $settings['secondary_color']; ?>;
            --color-primary: <?php echo $settings['primary_color']; ?>;
            --color-accent: <?php echo $settings['accent_color']; ?>;
            --color-light: <?php echo $settings['text_color']; ?>;
        }
        body {
            background-color: var(--color-dark);
            color: var(--color-light);
            font-family: 'Inter', sans-serif;
        }
        .input {
            width: 100%;
            padding: 0.75rem;
            border-radius: 0.375rem;
            background-color: #2d2d2d;
            color: var(--color-light);
            border: 1px solid #3d3d3d;
        }
        .input:focus {
            outline: none;
            border-color: var(--color-accent);
        }
        .btn {
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .btn-primary {
            background-color: var(--color-primary);
            color: white;
        }
        .btn-primary:hover {
            background-color: var(--color-accent);
        }
        .btn-secondary {
            background-color: #2d2d2d;
            color: var(--color-light);
        }
        .btn-secondary:hover {
            background-color: #3d3d3d;
        }
        .color-preview {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 10px;
            border: 2px solid #3d3d3d;
            vertical-align: middle;
        }
        .theme-preview {
            width: 100%;
            height: 200px;
            border-radius: 0.5rem;
            overflow: hidden;
            margin-bottom: 1.5rem;
            position: relative;
        }
        .theme-preview-header {
            height: 60px;
            background-color: <?php echo $settings['secondary_color']; ?>;
            display: flex;
            align-items: center;
            padding: 0 1rem;
        }
        .theme-preview-body {
            height: 140px;
            background-color: <?php echo $settings['background_type'] === 'color' ? $settings['background_color'] : '#121212'; ?>;
            <?php if ($settings['background_type'] === 'image' && !empty($settings['background_image'])): ?>
            background-image: url('../<?php echo $settings['background_image']; ?>');
            background-size: cover;
            background-position: center;
            <?php endif; ?>
            padding: 1rem;
            position: relative;
        }
        .theme-preview-card {
            width: 80%;
            height: 60px;
            background-color: <?php echo $settings['secondary_color']; ?>;
            border-radius: 0.5rem;
            margin: 0 auto;
            display: flex;
            align-items: center;
            padding: 0 1rem;
        }
        .theme-preview-button {
            background-color: <?php echo $settings['primary_color']; ?>;
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 0.375rem;
            font-size: 0.875rem;
            margin-left: auto;
        }
        .theme-preview-text {
            color: <?php echo $settings['text_color']; ?>;
        }
        .theme-preview-accent {
            color: <?php echo $settings['accent_color']; ?>;
        }
    </style>
</head>
<body>
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <?php include 'sidebar.php'; ?>
        
        <!-- Main Content -->
        <div class="flex-1 ml-64">
            <header class="bg-secondary p-4 shadow-md">
                <div class="flex justify-between items-center">
                    <h2 class="text-xl font-semibold text-light">Painel Administrativo</h2>
                    <div>
                        <a href="../index.php" target="_blank" class="btn btn-secondary text-sm">
                            Ver Página
                        </a>
                    </div>
                </div>
            </header>
            
            <main class="p-6">
                <div class="bg-secondary rounded-lg p-6 shadow-lg">
                    <div class="flex justify-between items-center mb-6">
                        <h1 class="text-2xl font-bold text-light">Personalização de Tema</h1>
                    </div>
                    
                    <?php if (isset($success) && $success): ?>
                        <div class="mb-4 p-3 rounded bg-green-900/30 border border-green-800 text-green-300">
                            Configurações de tema atualizadas com sucesso!
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($error) && !empty($error)): ?>
                        <div class="mb-4 p-3 rounded bg-red-900/30 border border-red-800 text-red-300">
                            <?php echo $error; ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="mb-8 bg-dark p-6 rounded-lg">
                        <h3 class="text-xl font-semibold text-light mb-4">Pré-visualização</h3>
                        
                        <div class="theme-preview">
                            <div class="theme-preview-header">
                                <div class="theme-preview-text font-bold">Renan Peterlini</div>
                            </div>
                            <div class="theme-preview-body">
                                <div class="theme-preview-card">
                                    <span class="theme-preview-text">Link de exemplo</span>
                                    <div class="theme-preview-button">Acessar</div>
                                </div>
                            </div>
                        </div>
                        
                        <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" enctype="multipart/form-data" class="space-y-6">
                            <div>
                                <h3 class="text-lg font-semibold text-light mb-4">Cores do Tema</h3>
                                
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label class="block text-sm font-medium text-gray-300 mb-1">
                                            Cor Primária
                                            <span class="color-preview" style="background-color: <?php echo $settings['primary_color']; ?>"></span>
                                        </label>
                                        <input
                                            type="color"
                                            name="primary_color"
                                            value="<?php echo $settings['primary_color']; ?>"
                                            class="input"
                                        />
                                        <p class="text-sm text-gray-400 mt-1">
                                            Usada para botões e elementos de destaque.
                                        </p>
                                    </div>
                                    
                                    <div>
                                        <label class="block text-sm font-medium text-gray-300 mb-1">
                                            Cor Secundária
                                            <span class="color-preview" style="background-color: <?php echo $settings['secondary_color']; ?>"></span>
                                        </label>
                                        <input
                                            type="color"
                                            name="secondary_color"
                                            value="<?php echo $settings['secondary_color']; ?>"
                                            class="input"
                                        />
                                        <p class="text-sm text-gray-400 mt-1">
                                            Usada para cabeçalhos, rodapés e cartões.
                                        </p>
                                    </div>
                                    
                                    <div>
                                        <label class="block text-sm font-medium text-gray-300 mb-1">
                                            Cor do Texto
                                            <span class="color-preview" style="background-color: <?php echo $settings['text_color']; ?>"></span>
                                        </label>
                                        <input
                                            type="color"
                                            name="text_color"
                                            value="<?php echo $settings['text_color']; ?>"
                                            class="input"
                                        />
                                        <p class="text-sm text-gray-400 mt-1">
                                            Cor principal para textos.
                                        </p>
                                    </div>
                                    
                                    <div>
                                        <label class="block text-sm font-medium text-gray-300 mb-1">
                                            Cor de Destaque
                                            <span class="color-preview" style="background-color: <?php echo $settings['accent_color']; ?>"></span>
                                        </label>
                                        <input
                                            type="color"
                                            name="accent_color"
                                            value="<?php echo $settings['accent_color']; ?>"
                                            class="input"
                                        />
                                        <p class="text-sm text-gray-400 mt-1">
                                            Usada para efeitos hover e elementos interativos.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="border-t border-gray-700 pt-6">
                                <h3 class="text-lg font-semibold text-light mb-4">Background da Página</h3>
                                
                                <div class="mb-4">
                                    <label class="block text-sm font-medium text-gray-300 mb-2">Tipo de Background</label>
                                    <div class="flex space-x-4">
                                        <label class="inline-flex items-center">
                                            <input 
                                                type="radio" 
                                                name="background_type" 
                                                value="color" 
                                                <?php echo $settings['background_type'] === 'color' ? 'checked' : ''; ?>
                                                class="mr-2"
                                                onclick="document.getElementById('background-color-section').style.display='block'; document.getElementById('background-image-section').style.display='none';"
                                            >
                                            Cor Sólida
                                        </label>
                                        <label class="inline-flex items-center">
                                            <input 
                                                type="radio" 
                                                name="background_type" 
                                                value="image" 
                                                <?php echo $settings['background_type'] === 'image' ? 'checked' : ''; ?>
                                                class="mr-2"
                                                onclick="document.getElementById('background-color-section').style.display='none'; document.getElementById('background-image-section').style.display='block';"
                                            >
                                            Imagem
                                        </label>
                                    </div>
                                </div>
                                
                                <div id="background-color-section" style="display: <?php echo $settings['background_type'] === 'color' ? 'block' : 'none'; ?>">
                                    <label class="block text-sm font-medium text-gray-300 mb-1">
                                        Cor de Background
                                        <span class="color-preview" style="background-color: <?php echo $settings['background_color']; ?>"></span>
                                    </label>
                                    <input
                                        type="color"
                                        name="background_color"
                                        value="<?php echo $settings['background_color']; ?>"
                                        class="input"
                                    />
                                    <p class="text-sm text-gray-400 mt-1">
                                        Cor de fundo da página principal.
                                    </p>
                                </div>
                                
                                <div id="background-image-section" style="display: <?php echo $settings['background_type'] === 'image' ? 'block' : 'none'; ?>">
                                    <label class="block text-sm font-medium text-gray-300 mb-1">
                                        Imagem de Background
                                    </label>
                                    <input
                                        type="file"
                                        name="background_image"
                                        class="input"
                                        accept="image/*"
                                    />
                                    <p class="text-sm text-gray-400 mt-1">
                                        Tamanho máximo: 5MB. Formatos permitidos: JPG, PNG, GIF, WEBP.
                                    </p>
                                    
                                    <?php if (!empty($settings['background_image'])): ?>
                                        <div class="mt-3">
                                            <p class="text-sm text-gray-300 mb-2">Imagem atual:</p>
                                            <div class="w-full h-32 rounded overflow-hidden">
                                                <img 
                                                    src="../<?php echo htmlspecialchars($settings['background_image']); ?>" 
                                                    alt="Background atual" 
                                                    class="w-full h-full object-cover"
                                                    onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';"
                                                >
                                                <div class="w-full h-full bg-gray-800 flex items-center justify-center text-gray-400" style="display: none;">
                                                    Imagem não disponível
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="flex space-x-3">
                                <button type="submit" class="btn btn-primary">
                                    Salvar Configurações
                                </button>
                                <a href="../index.php" target="_blank" class="btn btn-secondary">
                                    Visualizar Página
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>
