<?php
// Arquivo para rastrear cliques em links, banners e redes sociais
// Salve este arquivo como track_clicks.php na raiz do seu site

// Função para obter o endereço IP real do visitante
function getVisitorIP() {
    $ip = $_SERVER['REMOTE_ADDR'];
    
    // Verificar se está atrás de um proxy
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    
    return $ip;
}

// Função para determinar o tipo de dispositivo
function getDeviceType() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    
    if (preg_match('/(tablet|ipad|playbook)|(android(?!.*(mobi|opera mini)))/i', $user_agent)) {
        return 'tablet';
    }
    
    if (preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android|iemobile)/i', $user_agent)) {
        return 'mobile';
    }
    
    if (preg_match('/(ipod|iphone|ipad)/i', $user_agent)) {
        return 'mobile';
    }
    
    if (preg_match('/android/i', $user_agent)) {
        return 'mobile';
    }
    
    if (preg_match('/(blackberry|webos|windows phone|iemobile|opera mini)/i', $user_agent)) {
        return 'mobile';
    }
    
    return 'desktop';
}

// Função para obter a localização geográfica do visitante
function getVisitorLocation($ip) {
    // Usar API de geolocalização gratuita
    $api_url = "http://ip-api.com/json/{$ip}";
    
    // Inicializar valores padrão
    $location = [
        'country' => 'Unknown',
        'region' => 'Unknown',
        'city' => 'Unknown'
    ];
    
    // Tentar obter dados de localização
    try {
        $response = @file_get_contents($api_url);
        
        if ($response !== false) {
            $data = json_decode($response, true);
            
            if ($data && $data['status'] === 'success') {
                $location['country'] = $data['country'];
                $location['region'] = $data['regionName'];
                $location['city'] = $data['city'];
            }
        }
    } catch (Exception $e) {
        // Falha silenciosa, usar valores padrão
    }
    
    return $location;
}

// Função para gerar um ID de sessão único
function generateSessionId() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    if (empty($_SESSION['visitor_session_id'])) {
        $_SESSION['visitor_session_id'] = session_id() . '_' . time() . '_' . mt_rand(1000, 9999);
    }
    
    return $_SESSION['visitor_session_id'];
}

// Função para registrar clique em link
function trackLinkClick($conn, $link_id) {
    // Obter informações do visitante
    $ip = getVisitorIP();
    $device_type = getDeviceType();
    $location = getVisitorLocation($ip);
    $session_id = generateSessionId();
    
    // Preparar a consulta SQL
    $stmt = $conn->prepare("INSERT INTO link_clicks (
        link_id, 
        visitor_ip, 
        visitor_device_type, 
        visitor_country, 
        visitor_region, 
        session_id
    ) VALUES (?, ?, ?, ?, ?, ?)");
    
    // Verificar se a preparação foi bem-sucedida
    if ($stmt) {
        $stmt->bind_param(
            "isssss",
            $link_id,
            $ip,
            $device_type,
            $location['country'],
            $location['region'],
            $session_id
        );
        
        // Executar a consulta
        $stmt->execute();
        $stmt->close();
    }
}

// Função para registrar clique em banner
function trackBannerClick($conn, $banner_id) {
    // Obter informações do visitante
    $ip = getVisitorIP();
    $device_type = getDeviceType();
    $location = getVisitorLocation($ip);
    $session_id = generateSessionId();
    
    // Preparar a consulta SQL
    $stmt = $conn->prepare("INSERT INTO banner_clicks (
        banner_id, 
        visitor_ip, 
        visitor_device_type, 
        visitor_country, 
        visitor_region, 
        session_id
    ) VALUES (?, ?, ?, ?, ?, ?)");
    
    // Verificar se a preparação foi bem-sucedida
    if ($stmt) {
        $stmt->bind_param(
            "isssss",
            $banner_id,
            $ip,
            $device_type,
            $location['country'],
            $location['region'],
            $session_id
        );
        
        // Executar a consulta
        $stmt->execute();
        $stmt->close();
    }
}

// Função para registrar clique em rede social
function trackSocialClick($conn, $social_id) {
    // Obter informações do visitante
    $ip = getVisitorIP();
    $device_type = getDeviceType();
    $location = getVisitorLocation($ip);
    $session_id = generateSessionId();
    
    // Preparar a consulta SQL
    $stmt = $conn->prepare("INSERT INTO social_clicks (
        social_id, 
        visitor_ip, 
        visitor_device_type, 
        visitor_country, 
        visitor_region, 
        session_id
    ) VALUES (?, ?, ?, ?, ?, ?)");
    
    // Verificar se a preparação foi bem-sucedida
    if ($stmt) {
        $stmt->bind_param(
            "isssss",
            $social_id,
            $ip,
            $device_type,
            $location['country'],
            $location['region'],
            $session_id
        );
        
        // Executar a consulta
        $stmt->execute();
        $stmt->close();
    }
}

// Verificar se é uma solicitação AJAX para rastreamento
if (isset($_POST['track_type'])) {
    // Configurações de conexão com o banco de dados
    require_once 'config.php';
    
    // Inicializar resposta
    $response = ['success' => false];
    
    // Processar diferentes tipos de rastreamento
    switch ($_POST['track_type']) {
        case 'link':
            if (isset($_POST['link_id']) && is_numeric($_POST['link_id'])) {
                trackLinkClick($conn, (int)$_POST['link_id']);
                $response['success'] = true;
            }
            break;
            
        case 'banner':
            if (isset($_POST['banner_id']) && is_numeric($_POST['banner_id'])) {
                trackBannerClick($conn, (int)$_POST['banner_id']);
                $response['success'] = true;
            }
            break;
            
        case 'social':
            if (isset($_POST['social_id']) && is_numeric($_POST['social_id'])) {
                trackSocialClick($conn, (int)$_POST['social_id']);
                $response['success'] = true;
            }
            break;
    }
    
    // Retornar resposta JSON
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
