<?php
// Script de teste para verificar a funcionalidade de personalização de tema
// Salve este arquivo como test_theme_settings.php na raiz do seu site

// Configurações de conexão com o banco de dados
$db_host = 'localhost';
$db_user = 'seu_usuario'; // Altere para o seu usuário do banco de dados
$db_pass = 'sua_senha';   // Altere para a sua senha do banco de dados
$db_name = 'renanpeterlini'; // Altere para o nome do seu banco de dados

// Mensagem de status
$message = '';
$tests = [];

// Função para executar um teste
function runTest($name, $description, $testFunction) {
    global $tests;
    
    try {
        $result = $testFunction();
        $tests[] = [
            'name' => $name,
            'description' => $description,
            'status' => $result ? 'success' : 'failure',
            'message' => $result ? 'Teste passou com sucesso!' : 'Teste falhou!'
        ];
        return $result;
    } catch (Exception $e) {
        $tests[] = [
            'name' => $name,
            'description' => $description,
            'status' => 'error',
            'message' => 'Erro: ' . $e->getMessage()
        ];
        return false;
    }
}

// Processar o formulário quando enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verificar se a senha de segurança está correta
    $security_password = $_POST['security_password'] ?? '';
    
    if ($security_password !== 'testar123') { // Altere esta senha de segurança!
        $message = '<div class="error">Senha de segurança incorreta!</div>';
    } else {
        // Conectar ao banco de dados
        $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
        
        // Verificar conexão
        if ($conn->connect_error) {
            $message = '<div class="error">Falha na conexão com o banco de dados: ' . $conn->connect_error . '</div>';
        } else {
            // Teste 1: Verificar se a tabela settings existe
            runTest('Tabela settings', 'Verificar se a tabela settings existe', function() use ($conn) {
                $check_table = $conn->query("SHOW TABLES LIKE 'settings'");
                return $check_table->num_rows > 0;
            });
            
            // Teste 2: Verificar se as configurações de tema existem
            runTest('Configurações de tema', 'Verificar se as configurações de tema existem', function() use ($conn) {
                $theme_settings = [
                    'primary_color',
                    'secondary_color',
                    'text_color',
                    'accent_color',
                    'background_type',
                    'background_color',
                    'background_image'
                ];
                
                $all_exist = true;
                
                foreach ($theme_settings as $setting) {
                    $check_setting = $conn->prepare("SELECT id FROM settings WHERE setting_key = ?");
                    $check_setting->bind_param("s", $setting);
                    $check_setting->execute();
                    $result = $check_setting->get_result();
                    
                    if ($result->num_rows === 0) {
                        $all_exist = false;
                        break;
                    }
                    
                    $check_setting->close();
                }
                
                return $all_exist;
            });
            
            // Teste 3: Verificar se o diretório de upload para imagens de background existe
            runTest('Diretório de upload', 'Verificar se o diretório de upload para imagens de background existe', function() {
                $upload_dir = 'uploads/background';
                return file_exists($upload_dir);
            });
            
            // Teste 4: Verificar permissões de escrita no diretório de upload
            runTest('Permissões de escrita', 'Verificar permissões de escrita no diretório de upload', function() {
                $upload_dir = 'uploads/background';
                return is_writable($upload_dir);
            });
            
            // Teste 5: Verificar se o arquivo de administração de tema existe
            runTest('Arquivo de administração', 'Verificar se o arquivo de administração de tema existe', function() {
                return file_exists('admin/theme_settings.php');
            });
            
            // Teste 6: Verificar se o código de aplicação de tema está presente no frontend
            runTest('Código de aplicação de tema', 'Verificar se o código de aplicação de tema está presente no frontend', function() {
                if (!file_exists('index.php')) {
                    return false;
                }
                
                $content = file_get_contents('index.php');
                $patterns = [
                    'primary_color',
                    'secondary_color',
                    'text_color',
                    'accent_color',
                    'background_type',
                    'background_color',
                    'background_image'
                ];
                
                foreach ($patterns as $pattern) {
                    if (strpos($content, $pattern) === false) {
                        return false;
                    }
                }
                
                return true;
            });
            
            // Teste 7: Testar a atualização de uma configuração de tema
            runTest('Atualização de configuração', 'Testar a atualização de uma configuração de tema', function() use ($conn) {
                // Obter o valor atual
                $sql = "SELECT setting_value FROM settings WHERE setting_key = 'primary_color'";
                $result = $conn->query($sql);
                
                if ($result->num_rows === 0) {
                    return false;
                }
                
                $row = $result->fetch_assoc();
                $original_value = $row['setting_value'];
                
                // Atualizar para um valor de teste
                $test_value = '#FF0000';
                $sql = "UPDATE settings SET setting_value = ? WHERE setting_key = 'primary_color'";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("s", $test_value);
                $update_result = $stmt->execute();
                $stmt->close();
                
                if (!$update_result) {
                    return false;
                }
                
                // Verificar se a atualização foi bem-sucedida
                $sql = "SELECT setting_value FROM settings WHERE setting_key = 'primary_color'";
                $result = $conn->query($sql);
                
                if ($result->num_rows === 0) {
                    return false;
                }
                
                $row = $result->fetch_assoc();
                $updated_value = $row['setting_value'];
                
                // Restaurar o valor original
                $sql = "UPDATE settings SET setting_value = ? WHERE setting_key = 'primary_color'";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("s", $original_value);
                $stmt->execute();
                $stmt->close();
                
                return $updated_value === $test_value;
            });
            
            $conn->close();
            
            // Contar testes bem-sucedidos
            $success_count = 0;
            $total_tests = count($tests);
            
            foreach ($tests as $test) {
                if ($test['status'] === 'success') {
                    $success_count++;
                }
            }
            
            // Exibir mensagem de resumo
            if ($success_count === $total_tests) {
                $message = '<div class="success">Todos os testes foram concluídos com sucesso! A funcionalidade de personalização de tema está pronta para uso.</div>';
            } else {
                $message = '<div class="warning">Alguns testes falharam. Verifique os detalhes abaixo.</div>';
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Testar Funcionalidade de Personalização de Tema</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        h1 {
            color: #6d28d9;
            text-align: center;
        }
        .container {
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 20px;
            margin-top: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="password"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            background-color: #6d28d9;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background-color: #5b21b6;
        }
        .success {
            background-color: #d1fae5;
            border: 1px solid #10b981;
            color: #047857;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .error {
            background-color: #fee2e2;
            border: 1px solid #ef4444;
            color: #b91c1c;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .warning {
            background-color: #fffbeb;
            border: 1px solid #f59e0b;
            color: #b45309;
            padding: 10px;
            border-radius: 4px;
            margin: 15px 0;
        }
        .info {
            background-color: #e0f2fe;
            border: 1px solid #0ea5e9;
            color: #0369a1;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .test-success {
            color: #047857;
            font-weight: bold;
        }
        .test-failure {
            color: #b91c1c;
            font-weight: bold;
        }
        .test-error {
            color: #b45309;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h1>Testar Funcionalidade de Personalização de Tema</h1>
    
    <div class="container">
        <div class="info">
            Este script irá testar se a funcionalidade de personalização de tema foi implementada corretamente:
            <ul>
                <li>Verificar se a tabela settings existe</li>
                <li>Verificar se as configurações de tema existem</li>
                <li>Verificar se o diretório de upload para imagens de background existe</li>
                <li>Verificar se o arquivo de administração de tema existe</li>
                <li>Verificar se o código de aplicação de tema está presente no frontend</li>
                <li>Testar a atualização de uma configuração de tema</li>
            </ul>
        </div>
        
        <div class="warning">
            <strong>IMPORTANTE:</strong> Por segurança, exclua este arquivo do servidor após utilizá-lo!
        </div>
        
        <?php echo $message; ?>
        
        <?php if (!empty($tests)): ?>
            <h3>Resultados dos Testes:</h3>
            <table>
                <thead>
                    <tr>
                        <th>Teste</th>
                        <th>Descrição</th>
                        <th>Status</th>
                        <th>Mensagem</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($tests as $test): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($test['name']); ?></td>
                            <td><?php echo htmlspecialchars($test['description']); ?></td>
                            <td class="test-<?php echo $test['status']; ?>"><?php echo ucfirst($test['status']); ?></td>
                            <td><?php echo htmlspecialchars($test['message']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
                <div class="form-group">
                    <label for="security_password">Senha de Segurança:</label>
                    <input type="password" id="security_password" name="security_password" required>
                    <small>A senha de segurança padrão é: <strong>testar123</strong></small>
                </div>
                
                <button type="submit">Executar Testes</button>
            </form>
        <?php endif; ?>
    </div>
    
    <div class="container" style="margin-top: 20px;">
        <h3>Instruções:</h3>
        <ol>
            <li>Edite este arquivo para configurar corretamente a conexão com o banco de dados (linhas 6-8).</li>
            <li>Altere a senha de segurança (linha 38) para evitar uso não autorizado.</li>
            <li>Faça upload deste arquivo para a raiz do seu site.</li>
            <li>Acesse o arquivo pelo navegador: <code>https://seudominio.com.br/teste/test_theme_settings.php</code></li>
            <li>Digite a senha de segurança e clique em "Executar Testes".</li>
            <li>Verifique os resultados dos testes para garantir que tudo está funcionando corretamente.</li>
            <li>Após verificar os resultados, <strong>exclua este arquivo do servidor</strong>.</li>
        </ol>
    </div>
</body>
</html>
