<?php
require_once '../config.php';

// Verificar se o usuário está logado
if (!isLoggedIn()) {
    redirect('../login.php');
}

// Processar formulário de atualização de foto de perfil
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $success = false;
    $error = '';
    
    // Verificar se uma imagem foi enviada
    if (isset($_FILES['profile_photo']) && $_FILES['profile_photo']['error'] === 0) {
        $uploadDir = '../uploads/profile/';
        
        // Criar diretório se não existir
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        
        $fileName = basename($_FILES['profile_photo']['name']);
        $fileType = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        $newFileName = 'profile-' . time() . '.' . $fileType;
        $targetFile = $uploadDir . $newFileName;
        
        // Verificar se é uma imagem real
        $check = getimagesize($_FILES['profile_photo']['tmp_name']);
        if ($check === false) {
            $error = 'O arquivo não é uma imagem válida.';
        }
        // Verificar o tamanho do arquivo (máximo 2MB)
        elseif ($_FILES['profile_photo']['size'] > 2000000) {
            $error = 'O arquivo é muito grande. Tamanho máximo: 2MB.';
        }
        // Permitir apenas certos formatos de arquivo
        elseif ($fileType != "jpg" && $fileType != "png" && $fileType != "jpeg" && $fileType != "gif" && $fileType != "webp") {
            $error = 'Apenas arquivos JPG, JPEG, PNG, GIF e WEBP são permitidos.';
        }
        // Fazer upload do arquivo
        elseif (move_uploaded_file($_FILES['profile_photo']['tmp_name'], $targetFile)) {
            $photoUrl = 'uploads/profile/' . $newFileName;
            
            // Verificar se já existe uma foto de perfil
            $sql = "SELECT setting_value FROM settings WHERE setting_key = 'profile_photo'";
            $result = $conn->query($sql);
            
            if ($result->num_rows > 0) {
                // Obter a foto antiga
                $row = $result->fetch_assoc();
                $oldPhotoUrl = $row['setting_value'];
                
                // Excluir a foto antiga se existir
                if (!empty($oldPhotoUrl) && file_exists('../' . $oldPhotoUrl)) {
                    unlink('../' . $oldPhotoUrl);
                }
                
                // Atualizar a foto de perfil
                $sql = "UPDATE settings SET setting_value = ? WHERE setting_key = 'profile_photo'";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("s", $photoUrl);
            } else {
                // Inserir nova configuração
                $sql = "INSERT INTO settings (setting_key, setting_value) VALUES ('profile_photo', ?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("s", $photoUrl);
            }
            
            if ($stmt->execute()) {
                $success = true;
            } else {
                $error = 'Erro ao salvar a foto de perfil: ' . $conn->error;
            }
            
            $stmt->close();
        } else {
            $error = 'Ocorreu um erro ao fazer upload da imagem.';
        }
    } else {
        $error = 'Nenhuma imagem foi selecionada.';
    }
}

// Obter a foto de perfil atual
$currentPhoto = '';
$sql = "SELECT setting_value FROM settings WHERE setting_key = 'profile_photo'";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $currentPhoto = $row['setting_value'];
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Foto de Perfil - Painel Administrativo</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        :root {
            --color-dark: #121212;
            --color-secondary: #1e1e1e;
            --color-primary: #6d28d9;
            --color-accent: #8b5cf6;
            --color-light: #f3f4f6;
        }
        body {
            background-color: var(--color-dark);
            color: var(--color-light);
            font-family: 'Inter', sans-serif;
        }
        .input {
            width: 100%;
            padding: 0.75rem;
            border-radius: 0.375rem;
            background-color: #2d2d2d;
            color: var(--color-light);
            border: 1px solid #3d3d3d;
        }
        .input:focus {
            outline: none;
            border-color: var(--color-accent);
        }
        .btn {
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .btn-primary {
            background-color: var(--color-primary);
            color: white;
        }
        .btn-primary:hover {
            background-color: var(--color-accent);
        }
        .btn-secondary {
            background-color: #2d2d2d;
            color: var(--color-light);
        }
        .btn-secondary:hover {
            background-color: #3d3d3d;
        }
        .profile-photo-container {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            overflow: hidden;
            margin: 0 auto;
            background-color: #2d2d2d;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 3px solid var(--color-primary);
        }
        .profile-photo {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .photo-placeholder {
            font-size: 3rem;
            color: #4d4d4d;
        }
    </style>
</head>
<body>
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <?php include 'sidebar.php'; ?>
        
        <!-- Main Content -->
        <div class="flex-1 ml-64">
            <header class="bg-secondary p-4 shadow-md">
                <div class="flex justify-between items-center">
                    <h2 class="text-xl font-semibold text-light">Painel Administrativo</h2>
                    <div>
                        <a href="../index.php" target="_blank" class="btn btn-secondary text-sm">
                            Ver Página
                        </a>
                    </div>
                </div>
            </header>
            
            <main class="p-6">
                <div class="bg-secondary rounded-lg p-6 shadow-lg">
                    <div class="flex justify-between items-center mb-6">
                        <h1 class="text-2xl font-bold text-light">Foto de Perfil</h1>
                    </div>
                    
                    <?php if (isset($success) && $success): ?>
                        <div class="mb-4 p-3 rounded bg-green-900/30 border border-green-800 text-green-300">
                            Foto de perfil atualizada com sucesso!
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($error) && !empty($error)): ?>
                        <div class="mb-4 p-3 rounded bg-red-900/30 border border-red-800 text-red-300">
                            <?php echo $error; ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="mb-8 bg-dark p-6 rounded-lg">
                        <div class="text-center mb-6">
                            <div class="profile-photo-container mb-4">
                                <?php if (!empty($currentPhoto)): ?>
                                    <img 
                                        src="../<?php echo htmlspecialchars($currentPhoto); ?>" 
                                        alt="Foto de Perfil" 
                                        class="profile-photo"
                                        onerror="this.parentNode.innerHTML='<div class=\'photo-placeholder\'>👤</div>'"
                                    >
                                <?php else: ?>
                                    <div class="photo-placeholder">👤</div>
                                <?php endif; ?>
                            </div>
                            <h3 class="text-xl font-semibold text-light">
                                Renan Peterlini
                            </h3>
                            <p class="text-gray-400">
                                Esta foto será exibida na página principal
                            </p>
                        </div>
                        
                        <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" enctype="multipart/form-data" class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-300 mb-1">
                                    Nova Foto de Perfil
                                </label>
                                <input
                                    type="file"
                                    name="profile_photo"
                                    class="input"
                                    accept="image/*"
                                    required
                                />
                                <p class="text-sm text-gray-400 mt-1">
                                    Tamanho máximo: 2MB. Formatos permitidos: JPG, PNG, GIF, WEBP.
                                </p>
                                <p class="text-sm text-gray-400 mt-1">
                                    Recomendação: Use uma imagem quadrada para melhores resultados.
                                </p>
                            </div>
                            
                            <div class="flex space-x-3">
                                <button type="submit" class="btn btn-primary">
                                    Atualizar Foto de Perfil
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>
