<?php
require_once '../config.php';

// Verificar se o usuário está logado
if (!isLoggedIn()) {
    redirect('../login.php');
}

// Obter estatísticas
$stats = [
    'links' => 0,
    'banners' => 0,
    'socials' => 0
];

// Contar links ativos
$sql = "SELECT COUNT(*) as count FROM links WHERE is_active = 1";
$result = $conn->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $stats['links'] = $row['count'];
}

// Contar banners ativos
$sql = "SELECT COUNT(*) as count FROM banners WHERE is_active = 1";
$result = $conn->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $stats['banners'] = $row['count'];
}

// Contar redes sociais ativas
$sql = "SELECT COUNT(*) as count FROM socials WHERE is_active = 1";
$result = $conn->query($sql);
if ($result && $row = $result->fetch_assoc()) {
    $stats['socials'] = $row['count'];
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Painel Administrativo</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        :root {
            --color-dark: #121212;
            --color-secondary: #1e1e1e;
            --color-primary: #6d28d9;
            --color-accent: #8b5cf6;
            --color-light: #f3f4f6;
        }
        body {
            background-color: var(--color-dark);
            color: var(--color-light);
            font-family: 'Inter', sans-serif;
        }
        .btn {
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .btn-primary {
            background-color: var(--color-primary);
            color: white;
        }
        .btn-primary:hover {
            background-color: var(--color-accent);
        }
        .btn-secondary {
            background-color: #2d2d2d;
            color: var(--color-light);
        }
        .btn-secondary:hover {
            background-color: #3d3d3d;
        }
    </style>
</head>
<body>
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <?php include 'sidebar.php'; ?>
        
        <!-- Main Content -->
        <div class="flex-1 ml-64">
            <header class="bg-secondary p-4 shadow-md">
                <div class="flex justify-between items-center">
                    <h2 class="text-xl font-semibold text-light">Painel Administrativo</h2>
                    <div>
                        <a href="../index.php" target="_blank" class="btn btn-secondary text-sm">
                            Ver Página
                        </a>
                    </div>
                </div>
            </header>
            
            <main class="p-6">
                <div class="bg-secondary rounded-lg p-6 shadow-lg">
                    <h1 class="text-2xl font-bold text-light mb-6">Dashboard</h1>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div class="bg-dark p-4 rounded-lg">
                            <h3 class="text-lg font-medium text-light mb-2">Links</h3>
                            <p class="text-3xl font-bold text-accent"><?php echo $stats['links']; ?></p>
                            <p class="text-sm text-gray-400 mt-2">Links ativos</p>
                        </div>
                        
                        <div class="bg-dark p-4 rounded-lg">
                            <h3 class="text-lg font-medium text-light mb-2">Banners</h3>
                            <p class="text-3xl font-bold text-accent"><?php echo $stats['banners']; ?></p>
                            <p class="text-sm text-gray-400 mt-2">Banners ativos</p>
                        </div>
                        
                        <div class="bg-dark p-4 rounded-lg">
                            <h3 class="text-lg font-medium text-light mb-2">Redes Sociais</h3>
                            <p class="text-3xl font-bold text-accent"><?php echo $stats['socials']; ?></p>
                            <p class="text-sm text-gray-400 mt-2">Redes conectadas</p>
                        </div>
                    </div>
                    
                    <div class="mt-8">
                        <h2 class="text-xl font-semibold text-light mb-4">Ações Rápidas</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                            <a href="links.php" class="btn btn-primary text-center">Adicionar Link</a>
                            <a href="banners.php" class="btn btn-primary text-center">Adicionar Banner</a>
                            <a href="socials.php" class="btn btn-primary text-center">Adicionar Rede Social</a>
                            <a href="../index.php" target="_blank" class="btn btn-secondary text-center">Ver Página</a>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>
