<?php
// Arquivo para rastrear acessos à página
// Salve este arquivo como track_pageview.php na raiz do seu site

// Função para obter o endereço IP real do visitante
function getVisitorIP() {
    $ip = $_SERVER['REMOTE_ADDR'];
    
    // Verificar se está atrás de um proxy
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    
    return $ip;
}

// Função para determinar o tipo de dispositivo
function getDeviceType() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    
    if (preg_match('/(tablet|ipad|playbook)|(android(?!.*(mobi|opera mini)))/i', $user_agent)) {
        return 'tablet';
    }
    
    if (preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android|iemobile)/i', $user_agent)) {
        return 'mobile';
    }
    
    if (preg_match('/(ipod|iphone|ipad)/i', $user_agent)) {
        return 'mobile';
    }
    
    if (preg_match('/android/i', $user_agent)) {
        return 'mobile';
    }
    
    if (preg_match('/(blackberry|webos|windows phone|iemobile|opera mini)/i', $user_agent)) {
        return 'mobile';
    }
    
    return 'desktop';
}

// Função para obter o nome do dispositivo
function getDeviceName() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $device_name = 'Unknown';
    
    // Detectar dispositivos comuns
    if (preg_match('/iPhone/i', $user_agent)) {
        $device_name = 'iPhone';
    } elseif (preg_match('/iPad/i', $user_agent)) {
        $device_name = 'iPad';
    } elseif (preg_match('/Android/i', $user_agent)) {
        if (preg_match('/Samsung/i', $user_agent)) {
            $device_name = 'Samsung Android';
        } elseif (preg_match('/Pixel/i', $user_agent)) {
            $device_name = 'Google Pixel';
        } elseif (preg_match('/Xiaomi/i', $user_agent)) {
            $device_name = 'Xiaomi';
        } elseif (preg_match('/Huawei/i', $user_agent)) {
            $device_name = 'Huawei';
        } else {
            $device_name = 'Android';
        }
    } elseif (preg_match('/Macintosh/i', $user_agent)) {
        $device_name = 'Mac';
    } elseif (preg_match('/Windows/i', $user_agent)) {
        $device_name = 'Windows PC';
    } elseif (preg_match('/Linux/i', $user_agent)) {
        $device_name = 'Linux';
    }
    
    return $device_name;
}

// Função para obter o navegador
function getBrowser() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $browser = 'Unknown';
    
    if (preg_match('/MSIE/i', $user_agent) || preg_match('/Trident/i', $user_agent)) {
        $browser = 'Internet Explorer';
    } elseif (preg_match('/Firefox/i', $user_agent)) {
        $browser = 'Firefox';
    } elseif (preg_match('/Chrome/i', $user_agent)) {
        if (preg_match('/Edge/i', $user_agent)) {
            $browser = 'Edge';
        } elseif (preg_match('/Edg/i', $user_agent)) {
            $browser = 'Edge';
        } elseif (preg_match('/OPR/i', $user_agent)) {
            $browser = 'Opera';
        } else {
            $browser = 'Chrome';
        }
    } elseif (preg_match('/Safari/i', $user_agent)) {
        $browser = 'Safari';
    } elseif (preg_match('/Opera/i', $user_agent)) {
        $browser = 'Opera';
    }
    
    return $browser;
}

// Função para obter o sistema operacional
function getOS() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $os = 'Unknown';
    
    if (preg_match('/windows nt 10/i', $user_agent)) {
        $os = 'Windows 10';
    } elseif (preg_match('/windows nt 6.3/i', $user_agent)) {
        $os = 'Windows 8.1';
    } elseif (preg_match('/windows nt 6.2/i', $user_agent)) {
        $os = 'Windows 8';
    } elseif (preg_match('/windows nt 6.1/i', $user_agent)) {
        $os = 'Windows 7';
    } elseif (preg_match('/windows nt 6.0/i', $user_agent)) {
        $os = 'Windows Vista';
    } elseif (preg_match('/windows nt 5.2/i', $user_agent)) {
        $os = 'Windows Server 2003/XP x64';
    } elseif (preg_match('/windows nt 5.1/i', $user_agent)) {
        $os = 'Windows XP';
    } elseif (preg_match('/windows xp/i', $user_agent)) {
        $os = 'Windows XP';
    } elseif (preg_match('/macintosh|mac os x/i', $user_agent)) {
        if (preg_match('/Mac OS X 10_15/i', $user_agent)) {
            $os = 'macOS Catalina';
        } elseif (preg_match('/Mac OS X 10_14/i', $user_agent)) {
            $os = 'macOS Mojave';
        } elseif (preg_match('/Mac OS X 10_13/i', $user_agent)) {
            $os = 'macOS High Sierra';
        } else {
            $os = 'macOS';
        }
    } elseif (preg_match('/linux/i', $user_agent)) {
        $os = 'Linux';
    } elseif (preg_match('/ubuntu/i', $user_agent)) {
        $os = 'Ubuntu';
    } elseif (preg_match('/iphone|ipad|ipod/i', $user_agent)) {
        if (preg_match('/OS 13/i', $user_agent)) {
            $os = 'iOS 13';
        } elseif (preg_match('/OS 12/i', $user_agent)) {
            $os = 'iOS 12';
        } else {
            $os = 'iOS';
        }
    } elseif (preg_match('/android/i', $user_agent)) {
        if (preg_match('/Android 10/i', $user_agent)) {
            $os = 'Android 10';
        } elseif (preg_match('/Android 9/i', $user_agent)) {
            $os = 'Android 9';
        } else {
            $os = 'Android';
        }
    }
    
    return $os;
}

// Função para obter a localização geográfica do visitante
function getVisitorLocation($ip) {
    // Usar API de geolocalização gratuita
    $api_url = "http://ip-api.com/json/{$ip}";
    
    // Inicializar valores padrão
    $location = [
        'country' => 'Unknown',
        'region' => 'Unknown',
        'city' => 'Unknown'
    ];
    
    // Tentar obter dados de localização
    try {
        $response = @file_get_contents($api_url);
        
        if ($response !== false) {
            $data = json_decode($response, true);
            
            if ($data && $data['status'] === 'success') {
                $location['country'] = $data['country'];
                $location['region'] = $data['regionName'];
                $location['city'] = $data['city'];
            }
        }
    } catch (Exception $e) {
        // Falha silenciosa, usar valores padrão
    }
    
    return $location;
}

// Função para gerar um ID de sessão único
function generateSessionId() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    if (empty($_SESSION['visitor_session_id'])) {
        $_SESSION['visitor_session_id'] = session_id() . '_' . time() . '_' . mt_rand(1000, 9999);
    }
    
    return $_SESSION['visitor_session_id'];
}

// Função para registrar a visualização da página
function trackPageView($conn) {
    // Obter informações do visitante
    $ip = getVisitorIP();
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    $device_type = getDeviceType();
    $device_name = getDeviceName();
    $browser = getBrowser();
    $os = getOS();
    $location = getVisitorLocation($ip);
    $session_id = generateSessionId();
    $referrer = $_SERVER['HTTP_REFERER'] ?? '';
    
    // Preparar a consulta SQL
    $stmt = $conn->prepare("INSERT INTO page_views (
        visitor_ip, 
        visitor_user_agent, 
        visitor_device_type, 
        visitor_device_name, 
        visitor_browser, 
        visitor_os, 
        visitor_country, 
        visitor_region, 
        visitor_city, 
        session_id, 
        referrer_url
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
    // Verificar se a preparação foi bem-sucedida
    if ($stmt) {
        $stmt->bind_param(
            "sssssssssss",
            $ip,
            $user_agent,
            $device_type,
            $device_name,
            $browser,
            $os,
            $location['country'],
            $location['region'],
            $location['city'],
            $session_id,
            $referrer
        );
        
        // Executar a consulta
        $stmt->execute();
        $stmt->close();
    }
}

// Verificar se é uma solicitação AJAX para rastreamento
if (isset($_POST['track_type']) && $_POST['track_type'] === 'pageview') {
    // Configurações de conexão com o banco de dados
    require_once 'config.php';
    
    // Registrar a visualização da página
    trackPageView($conn);
    
    // Retornar resposta JSON
    header('Content-Type: application/json');
    echo json_encode(['success' => true]);
    exit;
}
