<?php
// Script de teste para verificar a funcionalidade de métricas e novas features
// Salve este arquivo como test_new_features.php na raiz do seu site

// Configurações de conexão com o banco de dados
$db_host = 'localhost';
$db_user = 'renanpet_renanbd'; // Altere para o seu usuário do banco de dados
$db_pass = '271217Ra@!';   // Altere para a sua senha do banco de dados
$db_name = 'renanpet_BD_BIO'; // Altere para o nome do seu banco de dados

// Mensagem de status
$message = '';
$tests = [];

// Função para executar um teste
function runTest($name, $description, $testFunction) {
    global $tests;
    
    try {
        $result = $testFunction();
        $tests[] = [
            'name' => $name,
            'description' => $description,
            'status' => $result ? 'success' : 'failure',
            'message' => $result ? 'Teste passou com sucesso!' : 'Teste falhou!'
        ];
        return $result;
    } catch (Exception $e) {
        $tests[] = [
            'name' => $name,
            'description' => $description,
            'status' => 'error',
            'message' => 'Erro: ' . $e->getMessage()
        ];
        return false;
    }
}

// Processar o formulário quando enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verificar se a senha de segurança está correta
    $security_password = $_POST['security_password'] ?? '';
    
    if ($security_password !== 'testar123') { // Altere esta senha de segurança!
        $message = '<div class="error">Senha de segurança incorreta!</div>';
    } else {
        // Conectar ao banco de dados
        $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
        
        // Verificar conexão
        if ($conn->connect_error) {
            $message = '<div class="error">Falha na conexão com o banco de dados: ' . $conn->connect_error . '</div>';
        } else {
            // Teste 1: Verificar se as tabelas de métricas existem
            runTest('Tabelas de métricas', 'Verificar se as tabelas de métricas existem', function() use ($conn) {
                $tables = ['page_views', 'link_clicks', 'banner_clicks', 'social_clicks'];
                $all_exist = true;
                
                foreach ($tables as $table) {
                    $check_table = $conn->query("SHOW TABLES LIKE '$table'");
                    if ($check_table->num_rows === 0) {
                        $all_exist = false;
                        break;
                    }
                }
                
                return $all_exist;
            });
            
            // Teste 2: Verificar se os arquivos de rastreamento existem
            runTest('Arquivos de rastreamento', 'Verificar se os arquivos de rastreamento existem', function() {
                $files = ['track_pageview.php', 'track_clicks.php'];
                $all_exist = true;
                
                foreach ($files as $file) {
                    if (!file_exists($file)) {
                        $all_exist = false;
                        break;
                    }
                }
                
                return $all_exist;
            });
            
            // Teste 3: Verificar se o arquivo de dashboard existe
            runTest('Dashboard de métricas', 'Verificar se o arquivo de dashboard existe', function() {
                return file_exists('admin/dashboard.php');
            });
            
            // Teste 4: Verificar se o arquivo de múltiplos banners existe
            runTest('Múltiplos banners', 'Verificar se o arquivo de múltiplos banners existe', function() {
                return file_exists('multi_banners.php');
            });
            
            // Teste 5: Verificar se a configuração do YouTube existe
            runTest('Configuração do YouTube', 'Verificar se a configuração do YouTube existe', function() use ($conn) {
                $sql = "SELECT COUNT(*) as count FROM settings WHERE setting_key IN ('youtube_channel_id', 'youtube_api_key')";
                $result = $conn->query($sql);
                $row = $result->fetch_assoc();
                return $row['count'] === 2;
            });
            
            // Teste 6: Verificar se o código de rastreamento está presente no frontend
            runTest('Código de rastreamento', 'Verificar se o código de rastreamento está presente no frontend', function() {
                if (!file_exists('index.php')) {
                    return false;
                }
                
                $content = file_get_contents('index.php');
                return strpos($content, 'track_pageview.php') !== false && 
                       strpos($content, 'track_clicks.php') !== false;
            });
            
            // Teste 7: Verificar se o código de múltiplos banners está presente no frontend
            runTest('Múltiplos banners no frontend', 'Verificar se o código de múltiplos banners está presente no frontend', function() {
                if (!file_exists('index.php')) {
                    return false;
                }
                
                $content = file_get_contents('index.php');
                return strpos($content, 'displayMultiBanners') !== false;
            });
            
            // Teste 8: Verificar se o código do último vídeo do YouTube está presente no frontend
            runTest('Último vídeo do YouTube', 'Verificar se o código do último vídeo do YouTube está presente no frontend', function() {
                if (!file_exists('index.php')) {
                    return false;
                }
                
                $content = file_get_contents('index.php');
                return strpos($content, 'displayLatestYoutubeVideo') !== false;
            });
            
            // Teste 9: Testar a inserção de uma visualização de página
            runTest('Inserção de visualização', 'Testar a inserção de uma visualização de página', function() use ($conn) {
                $sql = "INSERT INTO page_views (
                    visitor_ip, 
                    visitor_user_agent, 
                    visitor_device_type, 
                    visitor_device_name, 
                    visitor_browser, 
                    visitor_os, 
                    visitor_country, 
                    visitor_region, 
                    visitor_city, 
                    session_id, 
                    referrer_url
                ) VALUES (
                    '127.0.0.1', 
                    'Test User Agent', 
                    'desktop', 
                    'Test Device', 
                    'Test Browser', 
                    'Test OS', 
                    'Brazil', 
                    'São Paulo', 
                    'São Paulo', 
                    'test_session_id', 
                    'test_referrer'
                )";
                
                return $conn->query($sql);
            });
            
            // Teste 10: Testar a inserção de um clique em link
            runTest('Inserção de clique em link', 'Testar a inserção de um clique em link', function() use ($conn) {
                // Verificar se existe pelo menos um link
                $check_link = $conn->query("SELECT id FROM links LIMIT 1");
                if ($check_link->num_rows === 0) {
                    return false;
                }
                
                $link = $check_link->fetch_assoc();
                $link_id = $link['id'];
                
                $sql = "INSERT INTO link_clicks (
                    link_id, 
                    visitor_ip, 
                    visitor_device_type, 
                    visitor_country, 
                    visitor_region, 
                    session_id
                ) VALUES (
                    $link_id, 
                    '127.0.0.1', 
                    'desktop', 
                    'Brazil', 
                    'São Paulo', 
                    'test_session_id'
                )";
                
                return $conn->query($sql);
            });
            
            $conn->close();
            
            // Contar testes bem-sucedidos
            $success_count = 0;
            $total_tests = count($tests);
            
            foreach ($tests as $test) {
                if ($test['status'] === 'success') {
                    $success_count++;
                }
            }
            
            // Exibir mensagem de resumo
            if ($success_count === $total_tests) {
                $message = '<div class="success">Todos os testes foram concluídos com sucesso! As novas funcionalidades estão prontas para uso.</div>';
            } else {
                $message = '<div class="warning">Alguns testes falharam. Verifique os detalhes abaixo.</div>';
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Testar Novas Funcionalidades</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        h1 {
            color: #6d28d9;
            text-align: center;
        }
        .container {
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 20px;
            margin-top: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="password"] {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            background-color: #6d28d9;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background-color: #5b21b6;
        }
        .success {
            background-color: #d1fae5;
            border: 1px solid #10b981;
            color: #047857;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .error {
            background-color: #fee2e2;
            border: 1px solid #ef4444;
            color: #b91c1c;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .warning {
            background-color: #fffbeb;
            border: 1px solid #f59e0b;
            color: #b45309;
            padding: 10px;
            border-radius: 4px;
            margin: 15px 0;
        }
        .info {
            background-color: #e0f2fe;
            border: 1px solid #0ea5e9;
            color: #0369a1;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .test-success {
            color: #047857;
            font-weight: bold;
        }
        .test-failure {
            color: #b91c1c;
            font-weight: bold;
        }
        .test-error {
            color: #b45309;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h1>Testar Novas Funcionalidades</h1>
    
    <div class="container">
        <div class="info">
            Este script irá testar se as novas funcionalidades foram implementadas corretamente:
            <ul>
                <li>Sistema de métricas de acesso</li>
                <li>Rastreamento de cliques em links, banners e redes sociais</li>
                <li>Dashboard com gráficos</li>
                <li>Exibição de múltiplos banners</li>
                <li>Efeitos hover nos banners</li>
                <li>Integração com a API do YouTube</li>
            </ul>
        </div>
        
        <div class="warning">
            <strong>IMPORTANTE:</strong> Por segurança, exclua este arquivo do servidor após utilizá-lo!
        </div>
        
        <?php echo $message; ?>
        
        <?php if (!empty($tests)): ?>
            <h3>Resultados dos Testes:</h3>
            <table>
                <thead>
                    <tr>
                        <th>Teste</th>
                        <th>Descrição</th>
                        <th>Status</th>
                        <th>Mensagem</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($tests as $test): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($test['name']); ?></td>
                            <td><?php echo htmlspecialchars($test['description']); ?></td>
                            <td class="test-<?php echo $test['status']; ?>"><?php echo ucfirst($test['status']); ?></td>
                            <td><?php echo htmlspecialchars($test['message']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
                <div class="form-group">
                    <label for="security_password">Senha de Segurança:</label>
                    <input type="password" id="security_password" name="security_password" required>
                    <small>A senha de segurança padrão é: <strong>testar123</strong></small>
                </div>
                
                <button type="submit">Executar Testes</button>
            </form>
        <?php endif; ?>
    </div>
    
    <div class="container" style="margin-top: 20px;">
        <h3>Instruções:</h3>
        <ol>
            <li>Edite este arquivo para configurar corretamente a conexão com o banco de dados (linhas 6-8).</li>
            <li>Altere a senha de segurança (linha 38) para evitar uso não autorizado.</li>
            <li>Faça upload deste arquivo para a raiz do seu site.</li>
            <li>Acesse o arquivo pelo navegador: <code>https://seudominio.com.br/teste/test_new_features.php</code></li>
            <li>Digite a senha de segurança e clique em "Executar Testes".</li>
            <li>Verifique os resultados dos testes para garantir que tudo está funcionando corretamente.</li>
            <li>Após verificar os resultados, <strong>exclua este arquivo do servidor</strong>.</li>
        </ol>
    </div>
</body>
</html>
