<?php
// Script para criar ou atualizar a tabela sections no banco de dados
require_once 'config.php';

// Verificar se a tabela sections existe
$sql = "SHOW TABLES LIKE 'sections'";
$result = $conn->query($sql);
$table_exists = ($result && $result->num_rows > 0);

// Se a tabela não existir, criar
if (!$table_exists) {
    echo "Criando tabela 'sections'...\n";
    
    $sql = "CREATE TABLE sections (
        section_id VARCHAR(50) PRIMARY KEY,
        name VARCHAR(100) NOT NULL,
        order_position INT NOT NULL DEFAULT 0
    )";
    
    if ($conn->query($sql) === TRUE) {
        echo "Tabela 'sections' criada com sucesso!\n";
        
        // Inserir seções padrão
        $default_sections = [
            ['banner-section', 'Banners', 0],
            ['video-section', 'Último Vídeo', 1],
            ['links-section', 'Links', 2],
            ['social-section', 'Redes Sociais', 3]
        ];
        
        $insert_sql = "INSERT INTO sections (section_id, name, order_position) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($insert_sql);
        
        foreach ($default_sections as $section) {
            $stmt->bind_param("ssi", $section[0], $section[1], $section[2]);
            $stmt->execute();
            echo "Seção '{$section[1]}' inserida com sucesso!\n";
        }
        
        $stmt->close();
    } else {
        echo "Erro ao criar tabela 'sections': " . $conn->error . "\n";
    }
} else {
    echo "Tabela 'sections' já existe.\n";
    
    // Verificar se há seções cadastradas
    $sql = "SELECT COUNT(*) as count FROM sections";
    $result = $conn->query($sql);
    $row = $result->fetch_assoc();
    
    if ($row['count'] == 0) {
        echo "Nenhuma seção encontrada. Inserindo seções padrão...\n";
        
        // Inserir seções padrão
        $default_sections = [
            ['banner-section', 'Banners', 0],
            ['video-section', 'Último Vídeo', 1],
            ['links-section', 'Links', 2],
            ['social-section', 'Redes Sociais', 3]
        ];
        
        $insert_sql = "INSERT INTO sections (section_id, name, order_position) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($insert_sql);
        
        foreach ($default_sections as $section) {
            $stmt->bind_param("ssi", $section[0], $section[1], $section[2]);
            $stmt->execute();
            echo "Seção '{$section[1]}' inserida com sucesso!\n";
        }
        
        $stmt->close();
    } else {
        echo "Seções já cadastradas. Total: " . $row['count'] . "\n";
        
        // Listar seções existentes
        $sql = "SELECT * FROM sections ORDER BY order_position ASC";
        $result = $conn->query($sql);
        
        echo "\nSeções existentes:\n";
        echo "--------------------\n";
        
        while ($row = $result->fetch_assoc()) {
            echo "ID: " . $row['section_id'] . "\n";
            echo "Nome: " . $row['name'] . "\n";
            echo "Posição: " . $row['order_position'] . "\n";
            echo "--------------------\n";
        }
    }
}

echo "\nConfigurações da tabela 'sections' concluídas com sucesso!\n";
$conn->close();
