<?php
require_once 'config.php';

// Verificar se o usuário já está logado
if (isLoggedIn()) {
    redirect('admin/index.php');
}

$error = '';

// Processar o formulário de login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitize($_POST['username']);
    $password = $_POST['password'];
    
    if (empty($username) || empty($password)) {
        $error = 'Por favor, preencha todos os campos.';
    } else {
        // Verificar as credenciais
        $sql = "SELECT id, username, password FROM users WHERE username = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();
            
            // Verificar a senha
            if (password_verify($password, $user['password'])) {
                // Login bem-sucedido
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                
                // Redirecionar para o painel administrativo
                redirect('admin/index.php');
            } else {
                $error = 'Credenciais inválidas.';
            }
        } else {
            $error = 'Credenciais inválidas.';
        }
        
        $stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Painel Administrativo</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        :root {
            --color-dark: #121212;
            --color-secondary: #1e1e1e;
            --color-primary: #6d28d9;
            --color-accent: #8b5cf6;
            --color-light: #f3f4f6;
        }
        body {
            background-color: var(--color-dark);
            color: var(--color-light);
            font-family: 'Inter', sans-serif;
        }
        .input {
            width: 100%;
            padding: 0.75rem;
            border-radius: 0.375rem;
            background-color: #2d2d2d;
            color: var(--color-light);
            border: 1px solid #3d3d3d;
        }
        .input:focus {
            outline: none;
            border-color: var(--color-accent);
        }
        .btn {
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .btn-primary {
            background-color: var(--color-primary);
            color: white;
        }
        .btn-primary:hover {
            background-color: var(--color-accent);
        }
    </style>
</head>
<body>
    <div class="min-h-screen flex items-center justify-center">
        <div class="w-full max-w-md p-8 bg-secondary rounded-lg shadow-lg">
            <div class="text-center mb-8">
                <h1 class="text-2xl font-bold text-light">Painel Administrativo</h1>
                <p class="text-gray-400">Faça login para gerenciar sua página bio</p>
            </div>
            
            <?php if (!empty($error)): ?>
                <div class="bg-red-900/30 border border-red-800 text-red-300 px-4 py-3 rounded mb-4">
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" class="space-y-6">
                <div>
                    <label for="username" class="block text-sm font-medium text-gray-300 mb-1">
                        Usuário
                    </label>
                    <input
                        id="username"
                        name="username"
                        type="text"
                        required
                        class="input"
                        placeholder="Digite seu usuário"
                    />
                </div>
                
                <div>
                    <label for="password" class="block text-sm font-medium text-gray-300 mb-1">
                        Senha
                    </label>
                    <input
                        id="password"
                        name="password"
                        type="password"
                        required
                        class="input"
                        placeholder="Digite sua senha"
                    />
                </div>
                
                <div>
                    <button
                        type="submit"
                        class="btn btn-primary w-full"
                    >
                        Entrar
                    </button>
                </div>
            </form>
            
            <div class="mt-6 text-center">
                <a href="index.php" class="text-sm text-gray-400 hover:text-accent">
                    Voltar para a página principal
                </a>
            </div>
        </div>
    </div>
</body>
</html>
