<?php
require_once 'config.php';
require_once 'multi_banners.php';

// Obter links ativos
$sql = "SELECT * FROM links WHERE is_active = 1 ORDER BY order_position ASC";
$links_result = $conn->query($sql);

// Obter banners ativos (até 3)
$banners = getActiveBanners($conn, 3);

// Obter redes sociais ativas
$sql = "SELECT * FROM socials WHERE is_active = 1 ORDER BY order_position ASC";
$socials_result = $conn->query($sql);

// Obter foto de perfil
$profile_photo = '';
$profile_name = 'Renan Peterlini';
$profile_description = 'Jogador de Poker, entusiasta das apostas';

$sql = "SELECT setting_value FROM settings WHERE setting_key = 'profile_photo'";
$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $profile_photo = $row['setting_value'];
}

// Obter configurações de tema
$theme = [
    'primary_color' => '#6d28d9',
    'secondary_color' => '#1e1e1e',
    'text_color' => '#f3f4f6',
    'accent_color' => '#8b5cf6',
    'background_type' => 'color',
    'background_color' => '#121212',
    'background_image' => '',
    'gradient_start_color' => '#121212',
    'gradient_end_color' => '#2d2d2d',
    'gradient_direction' => 'to bottom'
];

$sql = "SELECT setting_key, setting_value FROM settings WHERE setting_key IN 
        ('primary_color', 'secondary_color', 'text_color', 'accent_color', 
         'background_type', 'background_color', 'background_image',
         'gradient_start_color', 'gradient_end_color', 'gradient_direction')";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $theme[$row['setting_key']] = $row['setting_value'];
    }
}

// Obter o último vídeo do YouTube
$latest_video = getLatestYoutubeVideo($conn);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Renan Peterlini</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        :root {
            --color-dark: <?php echo $theme['secondary_color']; ?>;
            --color-secondary: <?php echo $theme['secondary_color']; ?>;
            --color-primary: <?php echo $theme['primary_color']; ?>;
            --color-accent: <?php echo $theme['accent_color']; ?>;
            --color-light: <?php echo $theme['text_color']; ?>;
        }
        body {
            <?php if ($theme['background_type'] === 'color'): ?>
            background-color: <?php echo $theme['background_color']; ?>;
            <?php elseif ($theme['background_type'] === 'gradient'): ?>
            background: linear-gradient(<?php echo $theme['gradient_direction']; ?>, <?php echo $theme['gradient_start_color']; ?>, <?php echo $theme['gradient_end_color']; ?>);
            background-attachment: fixed;
            <?php else: ?>
            background-color: #121212; /* Fallback color */
            <?php endif; ?>
            
            <?php if ($theme['background_type'] === 'image' && !empty($theme['background_image'])): ?>
            background-image: url('<?php echo $theme['background_image']; ?>');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            <?php endif; ?>
            
            color: var(--color-light);
            font-family: 'Inter', sans-serif;
        }
        .container-custom {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
        }
        .bg-dark {
            background-color: var(--color-dark);
        }
        .bg-secondary {
            background-color: var(--color-secondary);
        }
        .bg-primary {
            background-color: var(--color-primary);
        }
        .text-light {
            color: var(--color-light);
        }
        .text-accent {
            color: var(--color-accent);
        }
        .shadow-custom {
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .link-card {
            display: block;
            padding: 1rem;
            background-color: var(--color-secondary);
            border-radius: 0.5rem;
            transition: all 0.3s ease;
            width: 100%;
            max-width: 320px;
            min-height: 70px;
            display: flex;
            align-items: center;
        }
        .link-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .social-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 3.5rem;
            height: 3.5rem;
            background-color: var(--color-primary);
            border-radius: 9999px;
            transition: all 0.3s ease;
        }
        .social-icon:hover {
            background-color: var(--color-accent);
            transform: scale(1.1);
        }
        .social-icon svg {
            width: 1.8rem;
            height: 1.8rem;
        }
        .social-icon img, .social-icon span {
            width: 1.8rem;
            height: 1.8rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }
        .profile-photo {
            width: 96px;
            height: 96px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--color-accent);
        }
        .content-wrapper {
            <?php if ($theme['background_type'] === 'image'): ?>
            background-color: rgba(0, 0, 0, 0.7);
            backdrop-filter: blur(5px);
            border-radius: 1rem;
            <?php endif; ?>
            padding: 1.5rem;
            margin: 1rem 0;
        }
        .banner-section {
            margin-bottom: 2.5rem;
        }
        .youtube-section {
            margin-bottom: 2.5rem;
        }
    </style>
</head>
<body>
    <header class="py-6 bg-secondary relative">
        <?php if (isset($latest_video['is_live']) && $latest_video['is_live']): ?>
        <div class="absolute top-2 right-4 z-10 flex items-center space-x-1">
            <span class="inline-block w-2 h-2 bg-red-600 rounded-full animate-ping absolute"></span>
            <span class="inline-block w-2 h-2 bg-red-600 rounded-full relative"></span>
            <div class="bg-red-600 text-white px-3 py-1 rounded-full font-bold text-sm shadow-lg">LIVE ON</div>
        </div>
        <?php endif; ?>
        <div class="container-custom">
            <div class="flex flex-col items-center justify-center">
                <?php if (!empty($profile_photo)): ?>
                    <img 
                        src="<?php echo htmlspecialchars($profile_photo); ?>" 
                        alt="<?php echo htmlspecialchars($profile_name); ?>" 
                        class="profile-photo mb-4"
                        onerror="this.src='https://via.placeholder.com/96x96?text=RP'"
                    >
                <?php else: ?>
                    <div class="w-24 h-24 rounded-full bg-primary flex items-center justify-center mb-4 text-3xl">
                        👤
                    </div>
                <?php endif; ?>
                <h1 class="text-2xl font-bold text-light"><?php echo htmlspecialchars($profile_name); ?></h1>
                <p class="text-gray-400"><?php echo htmlspecialchars($profile_description); ?></p>
            </div>
        </div>
    </header>

    <main class="container-custom py-8">
        <div class="content-wrapper">
            <?php
            // Obter a ordem das seções do banco de dados
            $sections = [];
            $sql = "SELECT * FROM sections ORDER BY order_position ASC";
            $sections_result = $conn->query($sql);
            
            if ($sections_result && $sections_result->num_rows > 0) {
                while ($row = $sections_result->fetch_assoc()) {
                    $sections[] = $row;
                }
            } else {
                // Ordem padrão se não houver dados no banco
                $sections = [
                    ['section_id' => 'banner-section', 'name' => 'Banners', 'order_position' => 0],
                    ['section_id' => 'video-section', 'name' => 'Último Vídeo', 'order_position' => 1],
                    ['section_id' => 'links-section', 'name' => 'Links', 'order_position' => 2],
                    ['section_id' => 'social-section', 'name' => 'Redes Sociais', 'order_position' => 3]
                ];
            }
            
            // Renderizar seções na ordem definida
            foreach ($sections as $section) {
                switch ($section['section_id']) {
                    case 'banner-section':
                        ?>
                        <!-- Banner Section -->
                        <section id="banner-section" class="banner-section mb-10">
                            <?php echo displayMultiBanners($banners); ?>
                        </section>
                        <?php
                        break;
                        
                    case 'video-section':
                        ?>
                        <!-- YouTube Section -->
                        <section id="video-section" class="youtube-section mb-10">
                            <h2 class="text-xl font-semibold text-light mb-4 text-center">
                                <?php echo (isset($latest_video['is_live']) && $latest_video['is_live']) ? 'Ao Vivo Agora' : 'Último Vídeo'; ?>
                            </h2>
                            <?php echo displayLatestYoutubeVideo($latest_video); ?>
                        </section>
                        <?php
                        break;
                        
                    case 'links-section':
                        ?>
                        <!-- Links Section -->
                        <section id="links-section" class="mb-10">
                            <h2 class="text-xl font-semibold text-light mb-4 text-center">Links</h2>
                            <div class="space-y-3 flex flex-col items-center">
                                <?php if ($links_result->num_rows > 0): ?>
                                    <?php while($link = $links_result->fetch_assoc()): ?>
                                        <a 
                                            href="<?php echo htmlspecialchars($link['url']); ?>" 
                                            target="_blank"
                                            class="link-card"
                                            data-link-id="<?php echo $link['id']; ?>"
                                        >
                                            <div class="flex items-center w-full">
                                                <?php if (!empty($link['image_url'])): ?>
                                                    <div class="w-12 h-12 rounded-lg overflow-hidden mr-4 bg-gray-800 flex-shrink-0">
                                                        <img 
                                                            src="<?php echo htmlspecialchars($link['image_url']); ?>" 
                                                            alt="<?php echo htmlspecialchars($link['title']); ?>" 
                                                            class="w-full h-full object-cover"
                                                            onerror="this.parentNode.innerHTML='<div class=\'w-10 h-10 rounded-full bg-primary flex items-center justify-center\'><span class=\'text-white\'><?php echo htmlspecialchars($link['icon']); ?></span></div>'"
                                                        >
                                                    </div>
                                                <?php else: ?>
                                                    <div class="w-10 h-10 rounded-full bg-primary flex items-center justify-center mr-4 flex-shrink-0">
                                                        <span class="text-white"><?php echo htmlspecialchars($link['icon']); ?></span>
                                                    </div>
                                                <?php endif; ?>
                                                <span class="text-light truncate"><?php echo htmlspecialchars($link['title']); ?></span>
                                            </div>
                                        </a>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <p class="text-gray-400 text-center">Nenhum link disponível no momento.</p>
                                <?php endif; ?>
                            </div>
                        </section>
                        <?php
                        break;
                        
                    case 'social-section':
                        ?>
                        <!-- Social Media Section -->
                        <section id="social-section" class="mb-10">
                            <h2 class="text-xl font-semibold text-light mb-4 text-center">Redes Sociais</h2>
                            <div class="flex flex-wrap gap-4 justify-center">
                                <?php if ($socials_result->num_rows > 0): ?>
                                    <?php while($social = $socials_result->fetch_assoc()): ?>
                                        <a 
                                            href="<?php echo htmlspecialchars($social['url']); ?>" 
                                            target="_blank"
                                            class="social-icon"
                                            title="<?php echo htmlspecialchars($social['platform']); ?>"
                                            data-social-id="<?php echo $social['id']; ?>"
                                        >
                                            <?php if (!empty($social['custom_icon_url'])): ?>
                                                <img 
                                                    src="<?php echo htmlspecialchars($social['custom_icon_url']); ?>" 
                                                    alt="<?php echo htmlspecialchars($social['platform']); ?>" 
                                                    class="w-6 h-6 object-contain"
                                                    onerror="this.parentNode.innerHTML='<span class=\'text-white\'><?php echo htmlspecialchars($social['icon']); ?></span>'"
                                                >
                                            <?php elseif (strpos($social['icon'], 'predefined:') === 0): ?>
                                                <?php 
                                                    $icon_key = substr($social['icon'], 11);
                                                    $predefined_icons = [
                                                        'instagram' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M12 2c2.717 0 3.056.01 4.122.06 1.065.05 1.79.217 2.428.465.66.254 1.216.598 1.772 1.153.509.5.902 1.105 1.153 1.772.247.637.415 1.363.465 2.428.047 1.066.06 1.405.06 4.122 0 2.717-.01 3.056-.06 4.122-.05 1.065-.218 1.79-.465 2.428a4.883 4.883 0 0 1-1.153 1.772c-.5.508-1.105.902-1.772 1.153-.637.247-1.363.415-2.428.465-1.066.047-1.405.06-4.122.06-2.717 0-3.056-.01-4.122-.06-1.065-.05-1.79-.218-2.428-.465a4.89 4.89 0 0 1-1.772-1.153 4.904 4.904 0 0 1-1.153-1.772c-.248-.637-.415-1.363-.465-2.428C2.013 15.056 2 14.717 2 12c0-2.717.01-3.056.06-4.122.05-1.066.217-1.79.465-2.428a4.88 4.88 0 0 1 1.153-1.772A4.897 4.897 0 0 1 5.45 2.525c.638-.248 1.362-.415 2.428-.465C8.944 2.013 9.283 2 12 2zm0 1.802c-2.67 0-2.987.01-4.04.059-.977.045-1.504.207-1.857.344-.467.182-.8.398-1.15.748-.35.35-.566.683-.748 1.15-.137.353-.3.88-.344 1.857-.047 1.053-.059 1.37-.059 4.04 0 2.67.01 2.988.059 4.04.045.977.207 1.504.344 1.857.182.466.399.8.748 1.15.35.35.683.566 1.15.748.353.137.88.3 1.857.344 1.054.047 1.37.059 4.04.059 2.67 0 2.987-.01 4.04-.059.977-.045 1.504-.207 1.857-.344.467-.182.8-.398 1.15-.748.35-.35.566-.683.748-1.15.137-.353.3-.88.344-1.857.047-1.054.059-1.37.059-4.04 0-2.67-.01-2.987-.059-4.04-.045-.977-.207-1.504-.344-1.857a3.097 3.097 0 0 0-.748-1.15 3.098 3.098 0 0 0-1.15-.748c-.353-.137-.88-.3-1.857-.344-1.053-.047-1.37-.059-4.04-.059zm0 3.063A5.135 5.135 0 1 1 12.002 17.2 5.135 5.135 0 0 1 12 6.865zM12 15.333a3.333 3.333 0 1 0 0-6.666 3.333 3.333 0 0 0 0 6.666zm6.533-8.671a1.2 1.2 0 1 1-2.4 0 1.2 1.2 0 0 1 2.4 0z"/></svg>',
                                                        'facebook' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>',
                                                        'twitter' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M18.901 1.153h3.68l-8.04 9.19L24 22.846h-7.406l-5.8-7.584-6.638 7.584H.474l8.6-9.83L0 1.154h7.594l5.243 6.932ZM17.61 20.644h2.039L6.486 3.24H4.298Z"/></svg>',
                                                        'youtube' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/></svg>',
                                                        'tiktok' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M12.525.02c1.31-.02 2.61-.01 3.91-.02.08 1.53.63 3.09 1.75 4.17 1.12 1.11 2.7 1.62 4.24 1.79v4.03c-1.44-.05-2.89-.35-4.2-.97-.57-.26-1.1-.59-1.62-.93-.01 2.92.01 5.84-.02 8.75-.08 1.4-.54 2.79-1.35 3.94-1.31 1.92-3.58 3.17-5.91 3.21-1.43.08-2.86-.31-4.08-1.03-2.02-1.19-3.44-3.37-3.65-5.71-.02-.5-.03-1-.01-1.49.18-1.9 1.12-3.72 2.58-4.96 1.66-1.44 3.98-2.13 6.15-1.72.02 1.48-.04 2.96-.04 4.44-.99-.32-2.15-.23-3.02.37-.63.41-1.11 1.04-1.36 1.75-.21.51-.15 1.07-.14 1.61.24 1.64 1.82 3.02 3.5 2.87 1.12-.01 2.19-.66 2.77-1.61.19-.33.4-.67.41-1.06.1-1.79.06-3.57.07-5.36.01-4.03-.01-8.05.02-12.07z"/></svg>',
                                                        'linkedin' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433a2.062 2.062 0 0 1-2.063-2.065 2.064 2.064 0 1 1 2.063 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/></svg>',
                                                        'pinterest' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 5.079 3.158 9.417 7.618 11.162-.105-.949-.199-2.403.041-3.439.219-.937 1.406-5.957 1.406-5.957s-.359-.72-.359-1.781c0-1.663.967-2.911 2.168-2.911 1.024 0 1.518.769 1.518 1.688 0 1.029-.653 2.567-.992 3.992-.285 1.193.6 2.165 1.775 2.165 2.128 0 3.768-2.245 3.768-5.487 0-2.861-2.063-4.869-5.008-4.869-3.41 0-5.409 2.562-5.409 5.199 0 1.033.394 2.143.889 2.741.099.12.112.225.085.345-.09.375-.293 1.199-.334 1.363-.053.225-.172.271-.401.165-1.495-.69-2.433-2.878-2.433-4.646 0-3.776 2.748-7.252 7.92-7.252 4.158 0 7.392 2.967 7.392 6.923 0 4.135-2.607 7.462-6.233 7.462-1.214 0-2.354-.629-2.758-1.379l-.749 2.848c-.269 1.045-1.004 2.352-1.498 3.146 1.123.345 2.306.535 3.55.535 6.607 0 11.985-5.365 11.985-11.987C23.97 5.39 18.592.026 11.985.026L12.017 0z"/></svg>',
                                                        'twitch' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M11.571 4.714h1.715v5.143H11.57zm4.715 0H18v5.143h-1.714zM6 0L1.714 4.286v15.428h5.143V24l4.286-4.286h3.428L22.286 12V0zm14.571 11.143l-3.428 3.428h-3.429l-3 3v-3H6.857V1.714h13.714Z"/></svg>',
                                                        'telegram' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M11.944 0A12 12 0 0 0 0 12a12 12 0 0 0 12 12 12 12 0 0 0 12-12A12 12 0 0 0 12 0a12 12 0 0 0-.056 0zm4.962 7.224c.1-.002.321.023.465.14a.506.506 0 0 1 .171.325c.016.093.036.306.02.472-.18 1.898-.962 6.502-1.36 8.627-.168.9-.499 1.201-.82 1.23-.696.065-1.225-.46-1.9-.902-1.056-.693-1.653-1.124-2.678-1.8-1.185-.78-.417-1.21.258-1.91.177-.184 3.247-2.977 3.307-3.23.007-.032.014-.15-.056-.212s-.174-.041-.249-.024c-.106.024-1.793 1.14-5.061 3.345-.48.33-.913.49-1.302.48-.428-.008-1.252-.241-1.865-.44-.752-.245-1.349-.374-1.297-.789.027-.216.325-.437.893-.663 3.498-1.524 5.83-2.529 6.998-3.014 3.332-1.386 4.025-1.627 4.476-1.635z"/></svg>',
                                                        'whatsapp' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/></svg>',
                                                        'discord' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M20.317 4.3698a19.7913 19.7913 0 00-4.8851-1.5152.0741.0741 0 00-.0785.0371c-.211.3753-.4447.8648-.6083 1.2495-1.8447-.2762-3.68-.2762-5.4868 0-.1636-.3933-.4058-.8742-.6177-1.2495a.077.077 0 00-.0785-.037 19.7363 19.7363 0 00-4.8852 1.515.0699.0699 0 00-.0321.0277C.5334 9.0458-.319 13.5799.0992 18.0578a.0824.0824 0 00.0312.0561c2.0528 1.5076 4.0413 2.4228 5.9929 3.0294a.0777.0777 0 00.0842-.0276c.4616-.6304.8731-1.2952 1.226-1.9942a.076.076 0 00-.0416-.1057c-.6528-.2476-1.2743-.5495-1.8722-.8923a.077.077 0 01-.0076-.1277c.1258-.0943.2517-.1923.3718-.2914a.0743.0743 0 01.0776-.0105c3.9278 1.7933 8.18 1.7933 12.0614 0a.0739.0739 0 01.0785.0095c.1202.099.246.1981.3728.2924a.077.077 0 01-.0066.1276 12.2986 12.2986 0 01-1.873.8914.0766.0766 0 00-.0407.1067c.3604.698.7719 1.3628 1.225 1.9932a.076.076 0 00.0842.0286c1.961-.6067 3.9495-1.5219 6.0023-3.0294a.077.077 0 00.0313-.0552c.5004-5.177-.8382-9.6739-3.5485-13.6604a.061.061 0 00-.0312-.0286zM8.02 15.3312c-1.1825 0-2.1569-1.0857-2.1569-2.419 0-1.3332.9555-2.4189 2.157-2.4189 1.2108 0 2.1757 1.0952 2.1568 2.419 0 1.3332-.9555 2.4189-2.1569 2.4189zm7.9748 0c-1.1825 0-2.1569-1.0857-2.1569-2.419 0-1.3332.9554-2.4189 2.1569-2.4189 1.2108 0 2.1757 1.0952 2.1568 2.419 0 1.3332-.946 2.4189-2.1568 2.4189Z"/></svg>',
                                                        'snapchat' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor"><path d="M12.206.793c.99 0 4.347.276 5.93 3.821.529 1.193.403 3.219.299 4.847l-.003.06c-.012.18-.022.345-.03.51.075.045.203.09.401.09.3-.016.659-.12 1.033-.301.165-.088.344-.104.464-.104.182 0 .359.029.509.09.45.149.734.479.734.838.015.449-.39.839-1.213 1.168-.089.029-.209.075-.344.119-.45.135-1.139.36-1.333.81-.09.224-.061.524.12.868l.015.015c.06.136 1.526 3.475 4.791 4.014.255.044.435.27.42.509 0 .075-.015.149-.045.225-.24.569-1.273.988-3.146 1.271-.059.091-.12.375-.164.57-.029.179-.074.36-.134.553-.076.271-.27.405-.555.405h-.03c-.135 0-.313-.031-.538-.074-.36-.075-.765-.135-1.273-.135-.3 0-.599.015-.913.074-.6.104-1.123.464-1.723.884-.853.599-1.826 1.288-3.294 1.288-.06 0-.119-.015-.18-.015h-.149c-1.468 0-2.427-.675-3.279-1.288-.599-.42-1.107-.779-1.707-.884-.314-.045-.629-.074-.928-.074-.54 0-.958.089-1.272.149-.211.043-.391.074-.54.074-.374 0-.523-.224-.583-.42-.061-.192-.09-.36-.135-.553-.045-.195-.105-.42-.164-.575-1.918-.222-2.95-.642-3.189-1.226-.031-.075-.045-.165-.045-.239-.015-.225.15-.465.42-.509 3.264-.54 4.73-3.879 4.791-4.02l.016-.029c.18-.345.224-.645.119-.869-.195-.434-.884-.658-1.332-.809-.121-.029-.24-.074-.346-.119-1.107-.435-1.257-.93-1.197-1.273.09-.479.674-.793 1.168-.793.146 0 .27.029.383.074.42.194.789.3 1.104.3.234 0 .384-.06.465-.105l-.007-.514c-.105-1.636-.225-3.651.307-4.837C7.392 1.077 10.739.807 11.727.807l.419-.015h.06z"/></svg>'
                                                    ];
                                                    if (isset($predefined_icons[$icon_key])) {
                                                        echo $predefined_icons[$icon_key];
                                                    } else {
                                                        echo '<span class="text-white">?</span>';
                                                    }
                                                ?>
                                            <?php else: ?>
                                                <span class="text-white"><?php echo htmlspecialchars($social['icon']); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <p class="text-gray-400 text-center w-full"></p>
                                <?php endif; ?>
                            </div>
                        </section>
                        <?php
                        break;
                }
            }
            ?>
        </div>
    </main>

    <footer class="py-6 bg-secondary">
        <div class="container-custom text-center">
            <p class="text-gray-400">© <?php echo date('Y'); ?> <b>+18</b> Aposta não é investimento - Jogue com Responsabilidade. <b>Renan Peterlini</b> Todos os direitos reservados.</p>
        </div>
    </footer>

    <?php echo getTrackingScript(); ?>
</body>
</html>
