<?php
// Página para monitorar o status do YouTube (livestream ON/OFF)
require_once '../config.php';
require_once '../multi_banners.php';

// Verificar se o usuário está logado
if (!isLoggedIn()) {
    redirect('../login.php');
}

// Obter o status atual do YouTube
$youtube_status = getLatestYoutubeVideo($conn);
$is_live = isset($youtube_status['is_live']) && $youtube_status['is_live'];

// Atualizar manualmente o status (para fins de teste)
$message = '';
if (isset($_POST['update_status'])) {
    $new_status = $_POST['status'] === 'live' ? 1 : 0;
    
    // Atualizar o status na tabela de configurações
    $sql = "INSERT INTO settings (setting_key, setting_value) VALUES ('youtube_livestream_status', ?) 
            ON DUPLICATE KEY UPDATE setting_value = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $new_status, $new_status);
    
    if ($stmt->execute()) {
        $message = 'Status atualizado com sucesso!';
        // Atualizar a variável para refletir a mudança imediatamente
        $is_live = $new_status == 1;
    } else {
        $message = 'Erro ao atualizar status: ' . $conn->error;
    }
    $stmt->close();
}

// Forçar atualização dos dados do YouTube
if (isset($_POST['refresh_youtube'])) {
    $youtube_status = getLatestYoutubeVideo($conn);
    $is_live = isset($youtube_status['is_live']) && $youtube_status['is_live'];
    $message = 'Dados do YouTube atualizados com sucesso!';
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Status do YouTube - Painel Administrativo</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        :root {
            --color-dark: #1e1e1e;
            --color-secondary: #1e1e1e;
            --color-primary: #6d28d9;
            --color-accent: #8b5cf6;
            --color-light: #f3f4f6;
        }
        body {
            background-color: var(--color-dark);
            color: var(--color-light);
            font-family: 'Inter', sans-serif;
        }
        .bg-dark {
            background-color: var(--color-dark);
        }
        .bg-secondary {
            background-color: var(--color-secondary);
        }
        .bg-primary {
            background-color: var(--color-primary);
        }
        .text-light {
            color: var(--color-light);
        }
        .text-accent {
            color: var(--color-accent);
        }
        .btn {
            padding: 0.5rem 1rem;
            border-radius: 0.375rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .btn-primary {
            background-color: var(--color-primary);
            color: white;
        }
        .btn-primary:hover {
            background-color: var(--color-accent);
        }
        .btn-secondary {
            background-color: #2d2d2d;
            color: var(--color-light);
        }
        .btn-secondary:hover {
            background-color: #3d3d3d;
        }
        .card {
            background-color: var(--color-secondary);
            border-radius: 0.5rem;
            padding: 1.5rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .status-indicator {
            width: 16px;
            height: 16px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 8px;
        }
        .status-on {
            background-color: #10b981;
            box-shadow: 0 0 8px #10b981;
        }
        .status-off {
            background-color: #6b7280;
        }
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 0.5rem 1rem;
            border-radius: 9999px;
            font-weight: 600;
        }
        .badge-live {
            background-color: rgba(239, 68, 68, 0.2);
            color: #ef4444;
            border: 1px solid #ef4444;
        }
        .badge-offline {
            background-color: rgba(107, 114, 128, 0.2);
            color: #9ca3af;
            border: 1px solid #6b7280;
        }
        .live-pulse {
            position: relative;
        }
        .live-pulse::before {
            content: '';
            position: absolute;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            background-color: #ef4444;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0% {
                transform: translateY(-50%) scale(0.95);
                box-shadow: 0 0 0 0 rgba(239, 68, 68, 0.7);
            }
            70% {
                transform: translateY(-50%) scale(1);
                box-shadow: 0 0 0 10px rgba(239, 68, 68, 0);
            }
            100% {
                transform: translateY(-50%) scale(0.95);
                box-shadow: 0 0 0 0 rgba(239, 68, 68, 0);
            }
        }
    </style>
</head>
<body>
    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <?php include 'sidebar.php'; ?>
        
        <!-- Main Content -->
        <div class="flex-1 ml-64">
            <header class="bg-secondary p-4 shadow-md">
                <div class="flex justify-between items-center">
                    <h2 class="text-xl font-semibold text-light">Status do YouTube</h2>
                    <div>
                        <a href="../index.php" target="_blank" class="btn btn-secondary text-sm">
                            Ver Página
                        </a>
                    </div>
                </div>
            </header>
            
            <main class="p-6">
                <?php if (!empty($message)): ?>
                    <div class="bg-primary bg-opacity-20 border border-primary text-light px-4 py-3 rounded mb-6">
                        <?php echo $message; ?>
                    </div>
                <?php endif; ?>
                
                <!-- Status do YouTube -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                    <div class="card">
                        <h3 class="text-lg font-semibold mb-4">Status da Transmissão</h3>
                        
                        <div class="flex items-center mb-6">
                            <div class="<?php echo $is_live ? 'badge-live live-pulse pl-10' : 'badge-offline'; ?> status-badge">
                                <?php if ($is_live): ?>
                                    LIVE ON
                                <?php else: ?>
                                    <span class="status-indicator status-off"></span> OFFLINE
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="mb-4">
                            <p class="text-gray-400 mb-2">Última verificação: <?php echo date('d/m/Y H:i:s'); ?></p>
                            <form method="post" action="">
                                <button type="submit" name="refresh_youtube" class="btn btn-secondary text-sm">
                                    Atualizar Dados do YouTube
                                </button>
                            </form>
                        </div>
                        
                        <?php if ($youtube_status['success']): ?>
                            <div class="mt-6">
                                <h4 class="font-medium mb-2">Último Conteúdo:</h4>
                                <div class="bg-dark p-3 rounded">
                                    <p class="font-medium"><?php echo htmlspecialchars($youtube_status['title']); ?></p>
                                    <p class="text-sm text-gray-400 mt-1">
                                        <?php echo $is_live ? 'Transmissão ao vivo' : 'Publicado em: ' . date('d/m/Y', strtotime($youtube_status['published_at'])); ?>
                                    </p>
                                    <a href="<?php echo $youtube_status['url']; ?>" target="_blank" class="text-accent text-sm mt-2 inline-block">
                                        Ver no YouTube
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="card">
                        <h3 class="text-lg font-semibold mb-4">Atualização Manual</h3>
                        <p class="text-gray-400 mb-4">Use esta opção apenas para testes. O status será automaticamente atualizado com base na API do YouTube.</p>
                        
                        <form method="post" action="">
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-400 mb-2">Status:</label>
                                <div class="flex space-x-4">
                                    <label class="inline-flex items-center">
                                        <input type="radio" name="status" value="live" class="form-radio text-primary" <?php echo $is_live ? 'checked' : ''; ?>>
                                        <span class="ml-2">LIVE ON</span>
                                    </label>
                                    <label class="inline-flex items-center">
                                        <input type="radio" name="status" value="offline" class="form-radio text-primary" <?php echo !$is_live ? 'checked' : ''; ?>>
                                        <span class="ml-2">OFFLINE</span>
                                    </label>
                                </div>
                            </div>
                            
                            <button type="submit" name="update_status" class="btn btn-primary">
                                Atualizar Status
                            </button>
                        </form>
                        
                        <div class="mt-6 p-3 bg-dark rounded">
                            <p class="text-sm text-gray-400">
                                <strong>Nota:</strong> Esta configuração manual será substituída pela próxima verificação automática da API do YouTube.
                            </p>
                        </div>
                    </div>
                </div>
                
                <!-- Configurações do YouTube -->
                <div class="card mb-6">
                    <h3 class="text-lg font-semibold mb-4">Configurações do YouTube</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h4 class="font-medium mb-2">Canal do YouTube</h4>
                            <p class="text-gray-400 mb-4">O ID do canal é usado para obter os vídeos e status de transmissão ao vivo.</p>
                            
                            <?php
                            $channel_id = '';
                            $sql = "SELECT setting_value FROM settings WHERE setting_key = 'youtube_channel_id'";
                            $result = $conn->query($sql);
                            if ($result && $result->num_rows > 0) {
                                $row = $result->fetch_assoc();
                                $channel_id = $row['setting_value'];
                            }
                            ?>
                            
                            <div class="bg-dark p-3 rounded">
                                <p class="text-sm">
                                    ID do Canal: <span class="font-mono"><?php echo !empty($channel_id) ? $channel_id : 'Não configurado'; ?></span>
                                </p>
                            </div>
                        </div>
                        
                        <div>
                            <h4 class="font-medium mb-2">API Key</h4>
                            <p class="text-gray-400 mb-4">A chave da API é necessária para acessar os dados do YouTube.</p>
                            
                            <?php
                            $api_key = '';
                            $sql = "SELECT setting_value FROM settings WHERE setting_key = 'youtube_api_key'";
                            $result = $conn->query($sql);
                            if ($result && $result->num_rows > 0) {
                                $row = $result->fetch_assoc();
                                $api_key = $row['setting_value'];
                            }
                            ?>
                            
                            <div class="bg-dark p-3 rounded">
                                <p class="text-sm">
                                    Status: <span class="<?php echo !empty($api_key) ? 'text-green-500' : 'text-red-500'; ?>">
                                        <?php echo !empty($api_key) ? 'Configurado' : 'Não configurado'; ?>
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <a href="settings.php" class="btn btn-secondary inline-block mt-2">
                            Editar Configurações
                        </a>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>
